/**
 * 
 */
package cs.arizona.tau.xml;

import org.w3c.dom.*;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Date;

//import cs.arizona.tau.test.*;
import cs.arizona.tau.time.*;

import cs.arizona.util.*;
/**
 * @author spjoshi
 *
 */
public class DataStub {
	
	private static ConventionalParser cp;
	private static ValidatorProperties vp;
	
	/**
	 * @param args0
	 */
	public static void main(String[] args) {
		init();
		//stubDataVersionGenerator();
		//stubDataSchemaMappnig();
		//stubDataSquashing();
		//stubDataUnSquashing();
		
		// Rui commented out this
		//stubTemporalValidator();
	}
	
	/**
	 *	DataStub for DoDataSchemaMapping
	 */
	private static void stubDataSchemaMappnig(){
		DoSchemaMapping doSchemaMapping = new DoSchemaMapping();
		Document repSchemaDoc;
		repSchemaDoc = doSchemaMapping.createRepresentationalSchema("D:/EclipseWorkspace/TXSchema/test_cases/Schema_Mapper/schema_and_example_winOlympic/bundle.xml", 0);
		cp.writeDocument(repSchemaDoc, "D:/EclipseWorkspace/TXSchema/test_cases/Schema_Mapper/schema_and_example_winOlympic/rep_schema.xml");

		repSchemaDoc = doSchemaMapping.createRepresentationalSchema("D:/EclipseWorkspace/TXSchema/test_cases/Schema_Mapper/TXSchema_TimeVarying/TXSchema_bundle.xml", 0);
		cp.writeDocument(repSchemaDoc, "D:/EclipseWorkspace/TXSchema/test_cases/Schema_Mapper/TXSchema_TimeVarying/rep_schema.xml");

		/* To get this example working, modify TargetIdentifier.java and DoDataSchemaMapping.java to set xmlSchemaName to "xsd:"
		*
		repSchemaDoc = doSchemaMapping.createRepresentationalSchema("D:/EclipseWorkspace/TXSchema/test_cases/Schema_Mapper/XSchema_TimeVarying/XMLSchema_bundle.xml", 0);
		cp.writeDocument(repSchemaDoc, "D:/EclipseWorkspace/TXSchema/test_cases/Schema_Mapper/XSchema_TimeVarying/rep_schema.xml");
		*/
	}
	
	private static void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
	}
	
	private static void stubDataSquashing(){
		String temporalBundle;
		String temporalDocument;
		String configFile;
        Document temporalDoc;
        DoSquashing doSquashing;

        // this is my stuff!! Rui
        String tempDataDir = "/tmp";
        
        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase1/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase1/company_tv.xml";
        configFile = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase1/config.xml";

        doSquashing = new DoSquashing(temporalBundle,-1);
		temporalDoc = doSquashing.squash(tempDataDir, configFile);
		cp.writeDocument(temporalDoc, temporalDocument);
        
        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase2/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase2/company_tv.xml";
        configFile = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase2/config.xml";

        doSquashing = new DoSquashing(temporalBundle,-1);
		temporalDoc = doSquashing.squash(tempDataDir, configFile);
		cp.writeDocument(temporalDoc, temporalDocument);

        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase3/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase3/company_tv.xml";
        configFile = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase3/config.xml";

        doSquashing = new DoSquashing(temporalBundle,-1);
		temporalDoc = doSquashing.squash(tempDataDir, configFile);
		cp.writeDocument(temporalDoc, temporalDocument);
	}
	
	private static void stubDataUnSquashing(){

		String temporalBundle;
		String temporalDocument;
		String configFile;
		String snapshotDate;

        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase1/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase1/company_tv.xml";
        configFile = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase1/config.xml";
        snapshotDate = "2002-11-10";
        // this is my stuff!! Rui
        String tempDataDir = "/tmp";
        
        stubDataUnSquashing(tempDataDir, temporalBundle, temporalDocument, configFile, snapshotDate);
        
        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase2/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase2/company_tv.xml";
        configFile = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase2/config.xml";
        snapshotDate = "2002-11-10";
        stubDataUnSquashing(tempDataDir, temporalBundle, temporalDocument, configFile, snapshotDate);

        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase3/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase3/company_tv.xml";
        configFile = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase3/config.xml";
        snapshotDate = "2002-11-10";
        stubDataUnSquashing(tempDataDir, temporalBundle, temporalDocument, configFile, snapshotDate);
	}
	
	private static void stubDataUnSquashing(String tempDataDir, String temporalBundle, String temporalDocument, String configFile, String snapshotDate){

		DoUnSquashing doUnSquashing;
		Hashtable snapshots;
		String configDir = temporalDocument.substring(0,temporalDocument.lastIndexOf("/")) + "/"; 
		String baseFileName = temporalDocument.substring(temporalDocument.lastIndexOf("/") + 1, temporalDocument.lastIndexOf(".xml"));
		
		//Testing for unSquash
		doUnSquashing = new DoUnSquashing(temporalBundle, -1);
		snapshots = doUnSquashing.unSquash(tempDataDir, temporalDocument);
		
		Enumeration enumeration = snapshots.keys();
		while (enumeration.hasMoreElements()){
			ITimePeriod tp = (ITimePeriod)enumeration.nextElement();
			Element e = (Element)snapshots.get(tp);
			Date beginDate = tp.getBeginDate();
			Date endDate = tp.getEndDate();
			String snapshotFile = configDir + baseFileName + "_" + beginDate.getYear() + "_" + beginDate.getMonth() + "_" + beginDate.getDate()
			+ "_" + endDate.getYear() + "_" + endDate.getMonth() + "_" + endDate.getDate() + ".xml";
			cp.writeElement(e, snapshotFile);
		}
		
		//Testing for getSnapshot
		String snapshotFile = configDir + "snapshot" + snapshotDate + ".xml";
		Document snapshotDoc = doUnSquashing.getSnapshot(temporalDocument, snapshotDate);
		cp.writeDocument(snapshotDoc, snapshotFile);
	}
	
	private static void stubTemporalValidator(String temp_data_dir){
		String temporalDocument;
		String temporalBundle;
		DoTemporalValidation doTemporalValidator;
		
        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase1/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase1/company_tv.xml";
		doTemporalValidator = new DoTemporalValidation(temporalBundle, -1);
		if (doTemporalValidator.validate(temp_data_dir, temporalDocument)){
			System.out.println("Validation Successful.");
		}else{
			System.out.println("Validation Failed.");
		}
        
        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase2/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase2/company_tv.xml";
		doTemporalValidator = new DoTemporalValidation(temporalBundle, -1);
		if (doTemporalValidator.validate(temp_data_dir, temporalDocument)){
			System.out.println("Validation Successful.");
		}else{
			System.out.println("Validation Failed.");
		}

        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase3/company_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/squash/testcase3/company_tv.xml";
		doTemporalValidator = new DoTemporalValidation(temporalBundle, -1);
		if (doTemporalValidator.validate(temp_data_dir, temporalDocument)){
			System.out.println("Validation Successful.");
		}else{
			System.out.println("Validation Failed.");
		}
	}
	
	private static void stubDataVersionGenerator(){
		/*DataVersionGenerator dvg = new DataVersionGenerator("D:/EclipseWorkspace/TXSchema/test_cases/dataversiongenerator/testcase3/company.xsd",
				"D:/EclipseWorkspace/TXSchema/test_cases/dataversiongenerator/testcase3/company_temp_anno.xml",
				"D:/EclipseWorkspace/TXSchema/test_cases/dataversiongenerator/testcase3/company.xml",
				"D:/EclipseWorkspace/TXSchema/test_cases/dataversiongenerator/domains");
		dvg.createNewVersions();*/
	}
}