/*
 * Created on Sep 13, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package cs.arizona.tau.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Collection;
import java.util.Date;

import org.w3c.dom.Element;
import org.w3c.dom.Document;

import cs.arizona.tau.time.ITemporalElement;
import cs.arizona.tau.time.TemporalElement;
import cs.arizona.tau.time.ITime;
import cs.arizona.tau.time.ITimePeriod;

/**
 * @author shailesh
 *
 * Representation of an Item. Item contains its ItemIdentifier and all of its versions. 
 * 
 */
public class BaseItem {

	public static int CONTENT_VARYING = 1;
	public static int CONTENT_CONSTANT = 2;
	
	public static int EXISTENCE_CONSTANT = 1;
	public static int EXISTENCE_VARYING_WITHOUT_GAPS = 2;
	public static int EXISTENCE_VARYING_WITH_GAPS = 3;
	
	public static int KIND_STATE =1 ;
	public static int KIND_EVENT = 2;
	
	/**
	 * Comment for <code>itemIdentifier</code>
	 */
	protected ArrayList versions = new ArrayList();
	protected ITemporalElement temporalElement = new TemporalElement();
	protected String target = null;
	protected String itemID = null;
	protected int timeDimension;

	/**
	 * 
	 */
	public BaseItem() {
		super();
	}
	
	/**
	 * 
	 */
	public BaseItem(BaseItem baseItem) {
		super();
		this.target = baseItem.target ;
		this.timeDimension = baseItem.timeDimension;
		Iterator versionIterator = baseItem.getVersionIterator();
		while (versionIterator.hasNext()){
			this.versions.add(((Element)versionIterator.next()).cloneNode(true));
		}
		this.temporalElement = baseItem.temporalElement.cloneElement();
	}
	
	/**
	 * @return Returns the target.
	 */
	public String getTarget() {
		return target;
	}
	/**
	 * @param target The target to set.
	 */
	public void setTarget(String target) {
		this.target = target;
	}
	/**
	 * @return Returns the versions.
	 */
	public Iterator getVersionIterator() {
		return versions.iterator();
	}

	public ITemporalElement getTemporalElement(){
		return temporalElement;
	}

	public void addVersion(Element e, ITime time1){
		versions.add(e);
		temporalElement.add(time1);
	}

	public Element getVersion(int index){
		return (Element)versions.get(index);
	}
	
	public void addVersionAll(Collection c1, ITemporalElement te){
		versions.addAll(c1);
		this.temporalElement.addAll(te.getAll());
	}

	/**
	 * Then function deletes all the versions of an item.
	 *
	 */
	public void clearVersions(){
		versions.clear();
		temporalElement.clear();
	}
	
	/**
	 * @return Returns the itemID.
	 */
	public String getItemID() {
		return itemID;
	}

	/**
	 * @param itemID The itemID to set.
	 */
	public void setItemID(String itemID) {
		this.itemID = itemID;
	}
	
	/**
	 * The function would create a corresponding _timeVarying element and return it.
	 * @param doc
	 * @return
	 */
	public Element createRefElement(Document doc){
	//Though the function is not used currently, it would be requried when the representation is changed to include _timeVarying support.	
		Element itemRefElement = doc.createElement(target.replace('/','_'));
		itemRefElement.setAttribute("itemRef",itemID);
		return itemRefElement;
	}
	
	/**
	 * The function removes the specified version element from the item.
	 * @param ev
	 */
	public boolean removeVersion(Element ev){
		Iterator versionIterator = versions.iterator();
		Iterator teIterator = temporalElement.iterator();
		
		while (versionIterator.hasNext()){
			Element currVersion = (Element)versionIterator.next();
			ITime currTime1 = (ITime)teIterator.next();
			
			if (currVersion == ev){
				versions.remove(ev);
				temporalElement.remove(currTime1);
				return true;
			}
		}
		return false;
	}

	/**
	 * @return Returns the numDimensions.
	 */
	public int getTimeDimension() {
		return timeDimension;
	}

	/**
	 * @param numDimensions The numDimensions to set.
	 */
	public void setTimeDimension(int numDimensions) {
		this.timeDimension = numDimensions;
	}
	
	/**
	 * The function returns the number of versions present in the current Item.
	 * @return
	 */
	public int getVersionCount(){
		return versions.size();
	}
	
	public void merge(Item item){
		Iterator versionIterator = item.getVersionIterator();
		Iterator teIterator = item.getTemporalElement().iterator();
		while (versionIterator.hasNext()){
			versions.add(versionIterator.next());
			temporalElement.add((ITime)teIterator.next());
		}
	}
	
	public Collection getVersions(){
		return versions;
	}
	
	public Element getVersionElement(ITime time1){
		Iterator teItr = this.temporalElement.iterator();
		Iterator versionItr = versions.iterator();
		while(teItr.hasNext()){
			Element e = (Element)versionItr.next();
			ITime currTime = (ITime)teItr.next();
			if (this.getTimeDimension() == 1){
				if ((currTime.getRelationship(time1) == ITimePeriod.A_EQUALS_B) ||
				(currTime.getRelationship(time1) == ITimePeriod.B_STARTS_A) ||
				(currTime.getRelationship(time1) == ITimePeriod.B_FINISHES_A)||
				(currTime.getRelationship(time1) == ITimePeriod.B_DURING_A)){
					return e;
				}
			}else{
				//Implement this part if the time Dimension is BITemporal.
			}
		}
		return null;
	}
	
	public Element getSnapshot(Date date){
		Iterator versionIterator = versions.iterator();
		Iterator teIterator = this.temporalElement.iterator();
		
		while((versionIterator.hasNext()) && (teIterator.hasNext())){
			ITimePeriod tp = (ITimePeriod)teIterator.next();
			Element version = (Element)versionIterator.next();
			if ((tp.getBeginDate().equals(date)) || ((tp.getBeginDate().before(date)) && (tp.getEndDate().after(date)))){
				return version;
			}
		}
		return null;
	}
}