/**
 * 
 */
package cs.arizona.tau.time;

import java.util.Iterator;

import org.w3c.dom.Document;

/**
 * @author spjoshi
 *
 */
public class TemporalRegion implements ITemporalRegion {

	private int numDimensions;
	private ITimePeriod validPeriod;
	private ITimePeriod transactionPeriod;
	/**
	 * 
	 */
	public TemporalRegion() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * 
	 */
	public TemporalRegion(int numDimensions, ITimePeriod validPeriod, ITimePeriod transactionPeriod) {
		super();
		this.numDimensions = numDimensions;
		this.validPeriod = validPeriod;
		this.transactionPeriod = transactionPeriod;
	}
	
	/**
	 * 
	 */
	public TemporalRegion(ITemporalRegion tr) {
		super();
		this.numDimensions = tr.getNumDimensions();
		this.validPeriod = tr.getValidPeriod();
		this.transactionPeriod = tr.getTransactionPeriod() ;
	}

	
	/* (non-Javadoc)
	 * @see cs.arizona.tau.time.ITemporalRegion#getNumDimensions()
	 */
	public int getNumDimensions() {
		return numDimensions;
	}

	/* (non-Javadoc)
	 * @see cs.arizona.tau.time.ITemporalRegion#getValidPeriod()
	 */
	public void setValidPeriod(ITimePeriod validPeriod) {
		this.validPeriod = validPeriod;
	}

	/* (non-Javadoc)
	 * @see cs.arizona.tau.time.ITemporalRegion#getValidPeriod()
	 */
	public void setTransactionPeriod(ITimePeriod transactionPeriod) {
		this.transactionPeriod = transactionPeriod;
	}
	
	/* (non-Javadoc)
	 * @see cs.arizona.tau.time.ITemporalRegion#getValidPeriod()
	 */
	public ITimePeriod getValidPeriod() {
		return validPeriod;
	}

	/* (non-Javadoc)
	 * @see cs.arizona.tau.time.ITemporalRegion#getTransactionPeriod()
	 */
	public ITimePeriod getTransactionPeriod() {
		return transactionPeriod;
	}

	/* (non-Javadoc)
	 * @see cs.arizona.tau.time.ITemporalRegion#overlap(cs.arizona.tau.time.ITemporalRegion)
	 */
	public boolean overlap(ITemporalRegion tr) {
		if ((validPeriod.getRelationship(tr.getValidPeriod())<=ITimePeriod.NO_OVERLAP) && (transactionPeriod.getRelationship(tr.getTransactionPeriod())<=ITimePeriod.NO_OVERLAP)){
			return false;
		}else{
			return true;
		}
	}

	/* (non-Javadoc)
	 * @see cs.arizona.tau.time.ITemporalRegion#isEqual(cs.arizona.tau.time.ITemporalRegion)
	 */
	public boolean isEqual(ITemporalRegion tr) {
		if ((validPeriod.getRelationship(tr.getValidPeriod())==ITimePeriod.A_EQUALS_B) && (transactionPeriod.getRelationship(tr.getTransactionPeriod())==ITimePeriod.A_EQUALS_B)){
			return true;
		}else{
			return false;
		}
		 
	}

	/* (non-Javadoc)
	 * @see cs.arizona.tau.time.ITemporalRegion#split(cs.arizona.tau.time.ITemporalRegion)
	 */
	public Iterator split(ITemporalRegion tr) {
		return null;
	}
	
	public String getInterfaceName(){
		return "ITemporalRegion";
	}
	
	public ITime cloneTime(){
		ITemporalRegion tr = new TemporalRegion(this.numDimensions,(ITimePeriod)this.validPeriod.cloneTime(),(ITimePeriod)this.transactionPeriod.cloneTime());
		return tr;
	}
	
	public int getRelationship(ITime time1){
		return 0;
	}

}
