package cs.arizona.tau.time;

import cs.arizona.tau.time.ITimePeriod;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class SCPList<E> implements ISCPList<E>, Iterable {
	private class PPair {
		TimePeriod tp;
		E ele;
		PPair(TimePeriod tp, E ele) {
			this.tp = tp;
			this.ele = ele;
		}
	}
		
	private ArrayList<PPair> scplist;
	
	public SCPList() {
		this.scplist = new ArrayList<PPair>();
	}
	
	public void add(TimePeriod tp, E ele) {
		scplist.add(new PPair(tp, ele));
	}

	
	public E get(Date b) {
		for(PPair pair : scplist) {
			Date before = pair.tp.getBeginDate();
			Date end = pair.tp.getEndDate();
			if (before.compareTo(b) <= 0 && end.compareTo(b) > 0) {
				return pair.ele;
			}
		}
		return null;
	}
	
	public E get(TimePeriod tp2) {
		for(PPair pair : scplist) {
			int relationship = pair.tp.getRelationship(tp2);
			if (relationship == TimePeriod.A_EQUALS_B || 
				relationship == TimePeriod.A_DURING_B ||
				relationship == TimePeriod.A_STARTS_B ) {
				return pair.ele;
			}
		}
		return null;
	}

	public E remove(Date b) {
		int i = 0;
		for(PPair pair : scplist) {
			Date before = pair.tp.getBeginDate();
			Date end = pair.tp.getEndDate();
			if (before.compareTo(b) <= 0 && end.compareTo(b) >= 0) {
				return scplist.remove(i).ele;
			}
			i++;
		}
		return null;		
	}
	
	public E remove(TimePeriod tp2) {
		int i = 0;
		for(PPair pair : scplist) {
			if (pair.tp.getRelationship(tp2) == ITimePeriod.A_EQUALS_B) {
				return scplist.remove(i).ele;
			}
			i++;
		}
		return null;
	}
	
	public Iterator<E> iterator() {
		return new SCPIterator<E>();
	}
	
	private class SCPIterator<E> implements Iterator<E> {
		
		ArrayList<PPair> list;
		int size;
		int i;
		
		public SCPIterator() {
			list = scplist;
			i = 0;
			size = list.size();
		}
		
		public boolean hasNext() {
			return i < size;
		}

		public E next() {
			return (E) list.get(i).ele;
		}

		public void remove() {
			
		}
				
	}

	
}
