package cs.arizona.tau.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class Period {
	private Date startDate;
	private Date endDate;
	
	public Period(String start, String end) throws ParseException {
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		try {
			startDate = df.parse(start);
			endDate = df.parse(end);
		} catch (ParseException e) {
			System.out.println("Invalid format for date.");
			throw e;
		}
		if(startDate.compareTo(endDate) > 0) {
			System.out.println("Error: The end of this period is before the start.");
		}
	}
	
	public Period(Date start, Date end) {
		startDate = start;
		endDate = end;
	}
	
	public boolean isBefore(Period other) {
		return endDate.compareTo(other.startDate) <= 0;
	}
	
	public boolean isAfter(Period other) {
		return startDate.compareTo(other.endDate) >= 0;
	}
	
	public boolean isDuring(Period other) {
		return startDate.compareTo(other.startDate) >= 0 && endDate.compareTo(other.endDate) <= 0;
	}
	
	public boolean contains(Date date) {
		return startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0;
	}
	
	public static List<Period> split(Period A, Period B) {
		LinkedList<Date> dateList = new LinkedList<Date>();
		LinkedList<Period> periodList = new LinkedList<Period>();
		dateList.add(A.startDate);
		dateList.add(A.endDate);
		dateList.add(B.startDate);
		dateList.add(B.endDate);
		Collections.sort(dateList);
		
		for(int i = 0; i < dateList.size() - 1; i++) {
			periodList.add(new Period(dateList.get(i), dateList.get(i + 1)));
		}
		
		return periodList;
	}
}
