/**
 * 
 */
package cs.arizona.tau.time;


import java.util.Date;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Document;

/**
 * @author spjoshi
 *
 */
public interface ITimePeriod extends ITime{

	public static int NO_OVERLAP		= 0;
	public static int A_BEFORE_B    	= -1;
	public static int B_BEFORE_A    	= -2;
	public static int A_MEETS_B    		= -3;
	public static int B_MEETS_A    		= -4;
	public static int A_OVERLAPS_B  	= 1;
	public static int B_OVERLAPS_A  	= 2;
	public static int A_EQUALS_B    	= 3;
	public static int A_STARTS_B    	= 4;
	public static int B_STARTS_A    	= 5;
	public static int A_FINISHES_B  	= 6;
	public static int B_FINISHES_A  	= 7;
	public static int A_DURING_B    	= 8;
	public static int B_DURING_A    	= 9;
	
	public static int TRANSACTION_TIME = 1;
	public static int VALID_TIME = 2;
	public static int BITEMPORAL_TIME = 3;
	
	public static int EXTENT_REP = 1;
	public static int STEP_REP = 2;
	
	public void setBeginDate(Date beginDate);
	public void setEndDate(Date endDate);
	public Date getBeginDate();
	public Date getEndDate();
	public Element toXML(int timeDimension, int timeRepresentation, Document doc);
	public Iterator split(ITimePeriod tp);
	public String getInterfaceName(); 
}
