/**
 * 
 */
package cs.arizona.tau.test;

import org.w3c.dom.*;

import cs.arizona.util.*;
import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;

import java.util.Hashtable;
import java.util.Random;
import java.util.ArrayList;

import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.Item;
import cs.arizona.tau.xml.BaseItem;

/**
 * @author spjoshi
 *
 */
public class DataVersionGenerator {
	
	private ConventionalParser cp;
	private ValidatorProperties vp;
	private Hashtable domains = new Hashtable();
	private Hashtable domainElementCount = new Hashtable();
	private LogicalAnnotationValidator tav;
	
	private Document snapshotDoc;
	
	private String documentDir = null;
	private String baseFileName = null;
	
	private Random random = new Random();
	
	int currVersionNumber = 0;
	
	/**
	 * 
	 */
	public DataVersionGenerator(String snapshotSchema, String temporalAnnotation, String snapshotDocument, String domainDir) {
		init();
		populateDomains(domainDir);
		tav = new LogicalAnnotationValidator(temporalAnnotation, snapshotSchema, true);
		snapshotDoc = cp.parseDocument(snapshotDocument, 
									"http://www.w3.org/2001/XMLSchema",
									snapshotSchema);
		documentDir = snapshotDocument.substring(0,snapshotDocument.lastIndexOf("/")) + "/";
		baseFileName = snapshotDocument.substring(snapshotDocument.lastIndexOf("/")+1, snapshotDocument.lastIndexOf("."));
	}
	
	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 */
	private void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
	}

	public void createNewVersions(){
		Document currDocVersion;
		currDocVersion = snapshotDoc;
		Element root;
		
		for (int i=0 ; i<10 ; i++ ){
			root = currDocVersion.getDocumentElement();
			modifyDocument(root,"/" + root.getNodeName());
			cp.writeDocument(currDocVersion, documentDir + baseFileName + i + ".xml");
		}
	}
	
	private void modifyDocument(Element element, String path){
		if (tav.containsTarget(path)){
			Item item = tav.getItemPrototype(path);
			modifyElement(element, item);
		}
		NodeList nl = element.getChildNodes();
		for (int i = 0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element e = (Element)nl.item(i);
				modifyDocument(e, path + "/" + e.getNodeName());
			}
		}
	}
	
	private void modifyElement(Element e, Item item){
		if (item.getContent() == BaseItem.CONTENT_VARYING){
			if (item.getExistence() == BaseItem.EXISTENCE_VARYING_WITHOUT_GAPS){
				if ((e.getAttribute("isDead") == null) || ("false".equals(e.getAttribute("isDead")))){
					if (random.nextBoolean() == true){
						e.setAttribute("isDead","true");
					}
				}
			}else{
				if (item.getExistence() == BaseItem.EXISTENCE_VARYING_WITH_GAPS){
					if ((e.getAttribute("isDead") == null) || ("false".equals(e.getAttribute("isDead")))){
						if (random.nextBoolean() == true){
							e.setAttribute("isDead","true");
						}
					}else{
						if (random.nextBoolean() == true){
							e.setAttribute("isDead","false");
						}
					}
				}
			}
			if (random.nextBoolean()){											/* If randomly generated boolean value is true */
				changeContents(e,item, ".");		/* Change contents */
			}								/* Else do not do anything */
		}else{
			if (item.getExistence() == BaseItem.EXISTENCE_VARYING_WITHOUT_GAPS){
				if ((e.getAttribute("isDead") == null) || ("false".equals(e.getAttribute("isDead")))){
					if (random.nextBoolean() == true){
						e.setAttribute("isDead","true");
					}
				}
			}else{
				if (item.getExistence() == BaseItem.EXISTENCE_VARYING_WITH_GAPS){
					if(random.nextBoolean() == true){
						if ("true".equals(e.getAttribute("isDead"))){
							e.setAttribute("isDead","false");
						}else{
							e.setAttribute("isDead","true");
						}
					}
				}
			}
		}
	}

	/* The function changes the contents of element e */
	private void changeContents(Element e, Item item, String relPath){
		NodeList nl = e.getChildNodes();
		for (int i=0 ; i<nl.getLength() ; i++){
			Node node = nl.item(i);
			if (node.getNodeType()==Node.ATTRIBUTE_NODE){
				if (!item.getItemIdentifier().getFieldTable().containsKey(relPath + "/@" + node.getNodeName())){
					node.setNodeValue((String)((ArrayList)domains.get(node.getNodeName())).get(random.nextInt(((Integer)domainElementCount.get(node.getNodeName())).intValue())));
				}
			}else{
				if ((node.getNodeType() == Node.TEXT_NODE) && (node.getNodeValue() != null) && !("".equals(node.getNodeValue().trim()))){
					//System.out.println(node.getNodeType());
					//System.out.println(node.getNodeValue());
					if (!item.getItemIdentifier().getFieldTable().containsKey(relPath + "/text")){
						node.setNodeValue((String)((ArrayList)domains.get(e.getNodeName())).get(random.nextInt(((Integer)domainElementCount.get(e.getNodeName())).intValue())));
					}
				}else{
					if ((node.getNodeType() == Node.ELEMENT_NODE) && !(tav.containsTarget(item.getItemIdentifier().getTarget() + "/" + relPath))){
						//System.out.println(relPath + "/" + node.getNodeName());
						//changeContents((Element)node,item,relPath + "/" + node.getNodeName());
					}
				}
			}
		}
		NamedNodeMap nnm = e.getAttributes();
		for (int i= 0 ;i < nnm.getLength() ; i++){
			Node node = nnm.item(i);
			if ((!item.getItemIdentifier().getFieldTable().containsKey(relPath + "/@" + node.getNodeName())) &&
					(domainElementCount.containsKey(node.getNodeName()))){
				node.setNodeValue((String)((ArrayList)domains.get(node.getNodeName())).get(random.nextInt(((Integer)domainElementCount.get(node.getNodeName())).intValue())));
			}
		}
	}

	private Node getNewDocument(Document masterDoc){
		Document tempDoc;
		Node node;
		tempDoc = cp.createDocument(null, "root", null );
		node= tempDoc.importNode(masterDoc.getDocumentElement(), true);
		filterDeadElements((Element)node);
		return node;
	}
	
	private void filterDeadElements(Element e){
		
		if ("true".equals(e.getAttribute("isDead"))){
			e.getParentNode().removeChild(e);
		}else{
			e.removeAttribute("isDead");
			NodeList nl = e.getChildNodes();
			for (int i=0 ; i<nl.getLength() ; i++){
				Node n = nl.item(i);
				if (n.getNodeType() == Node.ELEMENT_NODE){
					filterDeadElements((Element)n);
				}
			}
		}
	}
	
	/*
	 * The function populates domains table from some source (not yet decided. It could be a text file, XML file or database).
	 */
	private void populateDomains(String domainDirName){
		File domainDir = new File(domainDirName);
		String domainFiles[] = domainDir.list();
		BufferedReader br;
		String s;
		try{
			for (int i=0 ; i<domainFiles.length ; i++){
				int count = 0;
				ArrayList arrList = new ArrayList();
				br = new BufferedReader(new FileReader(domainDirName + System.getProperty("file.separator") + domainFiles[i]));
				while ((s = br.readLine()) != null){
					arrList.add(s);
					count++;
				}
				domains.put(domainFiles[i],arrList);
				domainElementCount.put(domainFiles[i],new Integer(count));
				//System.out.println(domainFiles[i]);
				
			}
		}catch(Exception e){
			e.printStackTrace();
		}
	}
}
