package cs.arizona.tau.docs;

import org.w3c.dom.DOMException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSException;

import cs.arizona.tau.time.Period;
import cs.arizona.tau.time.TemporalMap;
import cs.arizona.tau.xml.Common;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;

public class TemporalSchemaOld {
	private Document temporalSchemaDoc;
	private Element temporalSchema;
	private TemporalMap<ConventionalSchema> conventionalSchemas;
	private TemporalMap<AnnotationDocument> annotationDocuments;
	private String temporalSchemaDir;
	
	public TemporalSchemaOld(String tempSchema) {
		ValidatorProperties vp = ValidatorProperties.getInstance();
		ConventionalParser cp = ConventionalParser.getInstance();
		
		temporalSchemaDir = tempSchema.substring(0,tempSchema.lastIndexOf("/")) + "/";
		
		temporalSchemaDoc = cp.parseDocument(tempSchema, null, vp.getProperty("TSSchema"), false);
		if(temporalSchemaDoc.getDocumentElement().getLocalName().equals("schema")) {
			// Conventional Schema given
			temporalSchemaDoc = cp.createDocument(null, "tempralSchema", null);
			temporalSchema = temporalSchemaDoc.getDocumentElement();
			buildTemporalSchema(tempSchema);
		} else {
		  temporalSchema = temporalSchemaDoc.getDocumentElement();
		}
		
		conventionalSchemas = new TemporalMap<ConventionalSchema>();
		annotationDocuments = new TemporalMap<AnnotationDocument>();
		parseTemporalSchema(cp);
	}
	
	public TemporalSchemaOld(Document tempSchemaDoc) {
		ConventionalParser cp = ConventionalParser.getInstance();
		
		String tempSchema = tempSchemaDoc.getDocumentURI();
		temporalSchemaDir = tempSchema.substring(0,tempSchema.lastIndexOf("/")) + "/";
		
		if(tempSchemaDoc.getDocumentElement().getLocalName().equals("schema")) {
			// Conventional Schema given
			temporalSchemaDoc = cp.createDocument(null, "temporalSchema", null);
			temporalSchema = temporalSchemaDoc.getDocumentElement();
			buildTemporalSchema(tempSchemaDoc.getDocumentURI());
		} else {
			temporalSchemaDoc = tempSchemaDoc;
			temporalSchema = temporalSchemaDoc.getDocumentElement();
		}
		
		conventionalSchemas = new TemporalMap<ConventionalSchema>();
		annotationDocuments = new TemporalMap<AnnotationDocument>();
		parseTemporalSchema(cp);
	}
	
	public TemporalMap<AnnotationDocument> getAnnotationDocuments() {
		return annotationDocuments;
	}
	
	public TemporalMap<ConventionalSchema> getConventionalSchemas() {
		return conventionalSchemas;
	}
	
	public AnnotationDocument getAnnotationDocument(Period b) {
		return annotationDocuments.get(b);
	}
	
	public ConventionalSchema getConventionalSchema(Period b) {
		return conventionalSchemas.get(b);
	}
	
	private boolean parseTemporalSchema(ConventionalParser cp){
		
		NodeList     conventionalSchemaNode;
		NodeList	 convSchemasList;
		NodeList	 annotationNode;
		Element		 conventionalSchema;
		Element		 annotation;
		NodeList	 slices;
		Element		 slice;
		
        long t1 = System.nanoTime();
		
		try {
					
			//TODO: Should we require a namespace? For now, allow any.
			conventionalSchemaNode = temporalSchemaDoc.getElementsByTagNameNS("*", "conventionalSchema");
			
			if (conventionalSchemaNode.getLength() > 0) {
				convSchemasList = conventionalSchemaNode.item(0).getChildNodes();
				for(int i= 0; i < convSchemasList.getLength(); i++) {
					if(Common.isElement(convSchemasList.item(i))) {
						conventionalSchema = (Element) convSchemasList.item(i);
						if(conventionalSchema.getTagName().equals("include")) {
							//Get name of conventionalSchema documents.
							conventionalSchemas.add(new Period("0001-01-01","9999-12-31"), 
									new ConventionalSchema(temporalSchemaDir + conventionalSchema.getAttribute("schemaLocation")) );
						} else if(conventionalSchema.getTagName().equals("sliceSequence")) {
							slices = conventionalSchema.getElementsByTagName("slice");
							for(int j = 0; j < slices.getLength(); j++) {
								slice = (Element) slices.item(i);
								String end = slice.getAttribute("end");
								if(end.equals("") && i + 1 == slices.getLength()) {
									end = "9999-12-31";
								} else if(end.equals("")) {
									end = ((Element) slices.item(i+1)).getAttribute("begin");
								}
								conventionalSchemas.add(  new Period(slice.getAttribute("begin"), end ),
											new ConventionalSchema(temporalSchemaDir + slice.getAttribute("location") ) );
								
							}
						}
					}
				}
			}else{
				TauLogger.logger.info("No \"conventionalSchema\" elements in temporal schema!");
				//TODO: Err in some way
			}
			
			annotationNode = temporalSchemaDoc.getElementsByTagNameNS("*", "annotationSet");
			if(annotationNode.getLength() > 0) {
				annotationNode = annotationNode.item(0).getChildNodes();
				for(int i= 0; i < annotationNode.getLength(); i++) {
					if(Common.isElement(annotationNode.item(i))) {
						annotation = (Element) annotationNode.item(i);
						if(annotation.getTagName().equals("include")) {
							//Get name of annotation documents.
							annotationDocuments.add(new Period("0001-01-01","9999-12-31"), 
									new AnnotationDocument(temporalSchemaDir + annotation.getAttribute("location")) );
						} else if(annotation.getTagName().equals("sliceSequence")) {
							slices = annotation.getElementsByTagName("slice");
							for(int j = 0; j < slices.getLength(); j++) {
								slice = (Element) slices.item(i);
								String end = slice.getAttribute("end");
								if(end.equals("") && i + 1 == slices.getLength()) {
									end = "9999-12-31";
								} else if(end.equals("")) {
									end = ((Element) slices.item(i+1)).getAttribute("begin");
								}
								annotationDocuments.add(  new Period(slice.getAttribute("begin"),end ),
											new AnnotationDocument(temporalSchemaDir + slice.getAttribute("location")) );
								
							}
						}
					}
				}
			} else {
				TauLogger.logger.info("No \"annotationSet\" element in temporal schema");
			}
		}catch(DOMException de){
			System.out.println("Error occurred while parsing Temporal Bundle Document.");
			return false;
		}catch(LSException le){
			System.out.println("Unable to load Temporal Bundle Document.");
			le.printStackTrace();
			return false;
		}catch(Exception e){
			System.out.println("Some other error occurred.");
			e.printStackTrace();
			return false;
		}
        long t2 = System.nanoTime();
	    Common.printElaspedTime("parseBundle", t1, t2);
		return true;
	}
	
	// For use when a conventional schema is given instead of a temporal schema.
	private void buildTemporalSchema(String conventionalSchema) {
		Element conventionalSchemaEle = temporalSchemaDoc.createElement("conventionalSchema");
		Element includeEle = temporalSchemaDoc.createElement("include");
		includeEle.setAttribute("schemaLocation", conventionalSchema);
		conventionalSchemaEle.appendChild(includeEle);
		temporalSchema.appendChild(conventionalSchemaEle);
	}
}
