package cs.arizona.tau.docs;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import cs.arizona.util.ConventionalParser;
import cs.arizona.util.ValidatorProperties;

public class AnnotationDocument {
  private Document annotation_doc_;
  private Element annotation_set_;
  private Element logical_;
  private Element physical_;
  
  public AnnotationDocument(String annotation_doc_name) {
    ValidatorProperties vp = ValidatorProperties.getInstance();
    ConventionalParser cp = ConventionalParser.getInstance();
        
    annotation_doc_ = cp.parseDocument(
        annotation_doc_name, null,
        vp.getProperty("ASchema"));
    annotation_set_ = annotation_doc_.getDocumentElement();
    
    logical_ = null;
    physical_ = null;
    
    NodeList nl = annotation_set_.getElementsByTagName("logical");
    if(nl.getLength() > 0) {
      logical_ = (Element) nl.item(0);
    }
    nl = annotation_set_.getElementsByTagName("physical");
    if(nl.getLength() > 0) {
      physical_ = (Element) nl.item(0);
    }
  }
  
  
  public AnnotationDocument(Document annotation_doc) {    
    annotation_doc_ = annotation_doc;
    annotation_set_ = annotation_doc_.getDocumentElement();
    
    logical_ = null;
    physical_ = null;
    
    NodeList nl = annotation_set_.getElementsByTagName("logical");
    if(nl.getLength() > 0) {
      logical_ = (Element) nl.item(0);
    }
    nl = annotation_set_.getElementsByTagName("physical");
    if(nl.getLength() > 0) {
      physical_ = (Element) nl.item(0);
    }
  }
  
  
  /*
   * TODO: public AnnotationDocument(String eleName)
   *      - creates a default annotation document with timestamp
   *        at element eleName
   */
  
  public Element getLogicalAnnotations() {
    return logical_;
  }
  
  
  public Element getPhysicalAnnotations() {
    return physical_;
  }
  
  
  public Document GetAnnotationDocument() {
    return annotation_doc_;
  }
}
