#!/usr/bin/perl
use strict;


my $numIi = `grep "\\<item_RepItem" output.final.xml | wc -l`;
my $numIv = `grep "\\<item_Version" output.final.xml | wc -l`;
my $numI  = `grep "\\<item " output.final.xml | wc -l`;

my $numAi = `grep "\\<author_RepItem" output.final.xml | wc -l`;
my $numAv = `grep "\\<author_Version" output.final.xml | wc -l`;
my $numA  = `grep "\\<author " output.final.xml | wc -l`;

my $numPi = `grep "\\<publisher_RepItem" output.final.xml | wc -l`;
my $numPv = `grep "\\<publisher_Version" output.final.xml | wc -l`;
my $numP  = `grep "\\<publisher " output.final.xml | wc -l`;

my $numRi = `grep "\\<related_items_RepItem" output.final.xml | wc -l`;
my $numRv = `grep "\\<related_items_Version" output.final.xml | wc -l`;
my $numR  = `grep "\\<related_items " output.final.xml | wc -l`;

print "item_RepItem:          $numIi";
print "item_Version:          $numIv";
print "item:                  $numI";
print "author_RepItem:        $numAi";
print "author_Version:        $numAv";
print "author:                $numA";
print "publisher_RepItem:     $numPi";
print "publisher_Version:     $numPv";
print "publisher:             $numP";
print "related_items_RepItem: $numRi";
print "related_items_Version: $numRv";
print "related_items:         $numR";

print "\n";

my $total  = $numIi + $numAi + $numPi + $numRi;
my $totalV = $numIv + $numAv + $numPv + $numRv;
print "Total temporal elements (*RepItem): $total\n";
print "Total temporal versions (*Version): $totalV\n";

my $diff = $totalV - $total;
print "Difference: $diff\n";

print "\n";

getSize('output.final.xml', 1);
getSize('item.final.csv', 0);
getSize('author.final.csv', 0);
getSize('publisher.final.csv', 0);
getSize('related_item.final.csv', 0);
getSize('item_author.final.csv', 0);
getSize('item_publisher.final.csv', 0);

my $firstFile = `ls -1 output.2*.xml | head -1`;
my $lastFile = `ls -1 output.2*.xml | tail -1`;
chomp $firstFile;
chomp $lastFile;
getSize($firstFile, 1);
getSize($lastFile, 1);

my $totalSize=`du -s .`;
print "Total size: $totalSize";

exit;

sub getSize(){
    my $file = shift;
    my $xml = shift;

    my $size = -s $file;
    $size /= (1024*1024);

    my $lines = 0;

    if ($xml == 0){
        $lines = `wc -l $file | awk '{print \$1}'`;
    } else {
        $lines  = `grep "\\<item " $file | wc -l`;
    }
    chomp $lines;

    printf "$file: %.1fMB ($lines)\n", $size;
}
