/*
 *	tCorruptor - Corrupts a temporal document.
 *  Copyright (C) 2010  Stephen W. Thomas
 *
 *   This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import javax.xml.transform.Transformer;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Random;
import java.util.List;



public class tCorruptor
{
	static Random generator 				= new Random(1);

	static Document inputDocument;
	static Document outputDocument;
	
	static XPath xpath = XPathFactory.newInstance().newXPath();
	
	public static void main(String[] args) throws Exception{

        if (args.length != 2){
		    System.out.println("tCorruptor: Incorrect Usage.");
		    System.out.println("tCorruptor input_file action");
        }

        String inputFile = args[0];
        int action = Integer.parseInt(args[1]);

		// Read Input document
		if(!(new File(inputFile)).exists()){
			System.err.printf("Error! File \""+inputFile+"\" doesn't exist.");
			System.exit(2);
		}
		System.out.println("tCorruptor: Reading input file...");
		DOMParser parser = new DOMParser();
		parser.parse(inputFile);
		inputDocument = parser.getDocument();
		System.out.println("tCorruptor: done.");
		
		
		// Create output document
        outputDocument = copyDocument(inputDocument);


        // Perform the corruption
		System.out.println("tCorruptor: Corrupting...");
		switch(action){
			case 0: break;
			case 1: corruptAuthorsSequenced(); break;
			case 2: corruptRelatedItemSequenced(); break;
			case 3: corruptISBNSequenced(); break;
			case 4: corruptNumberOfPagesSequenced(); break;
			case 5:	corruptItemIDNonseqquenced(); break;
			case 6: corruptRelatedItemNonsequenced(); break;
			case 7: corruptAuthorsNonsequenced(); break;
			default: System.err.println("Error: action "+action+" unknown.");
		}
		System.out.println("tCorruptor: done.");

		// Write output document
		System.out.println("tCorruptor: Writing output file...");
        writeXmlFile(outputDocument, "output.new.xml");
		System.out.println("tCorruptor: done.");

	}

	// Idea: Choose a <author_RepItem> and replicate it 6 times, changing the author_ids each time.
	private static void corruptAuthorsNonsequenced() {
		Node victim = getSingleNodeXPath("//author_RepItem", outputDocument);
        Node parent = victim.getParentNode();
        
        //printNode(parent);
        
        for (int i =1; i <= 6; ++i){
        	Node newNode = victim.cloneNode(true);
        	
        	NodeList authors = getAllNodesXPath(".//author", newNode);
        	
        	for (int j = 0; j < authors.getLength(); ++j){
	        	// Set id attribute
	        	
	        	Node thisAuthor = authors.item(j);
	        	String thisId = ((Element) thisAuthor).getAttribute("author_id");
	        	((Element) thisAuthor).setAttribute("author_id", thisId+"321342"+i);
        	}
        	
        	parent.appendChild(newNode);
        }
        
        //printNode(parent);
	}

	// Idea: Choose a related item in 2010-01-01 and corrupt the value. 
	private static void corruptRelatedItemNonsequenced() {
		String firstTime = getTimeFromXPath("", outputDocument, 1);
		Node victim = getSingleNodeXPath("//item_id[../../../../../../@begin='"+firstTime+"']", outputDocument);
        printNode(victim);
        String thisId = ((Element) victim).getTextContent();
    	((Element) victim).setTextContent(thisId+"321342009989");
        printNode(victim);
	}

	// Idea: get an ID from an item at time 1; then select a random item from a random other time,
	// and copy the ID over.
	private static void corruptItemIDNonseqquenced() {
		
		String time1 = getTimeFromXPath("", outputDocument, 1);
		String time2 = getTimeFromXPath("", outputDocument, 10);
		
		Node source = getSingleNodeXPath("//item[../@begin='"+time1+"']", outputDocument);
		Node victim = getSingleNodeXPath("//item[../@begin='"+time2+"']", outputDocument);
		
		printNode(victim);
		String thisId = ((Element) source).getAttribute("id");
		((Element) victim).setAttribute("id", thisId);
		printNode(victim);
	}

	// Idea: get a number_of_pages, set it to a string
	private static void corruptNumberOfPagesSequenced() {
		Node victim = getSingleNodeXPath("//number_of_pages", outputDocument);
		printNode(victim);
		((Element) victim).setTextContent("NotAShort");
		printNode(victim);
	}

	// Idea: get two ISBNs, and set one to the other
	private static void corruptISBNSequenced() {
		Node source = getSingleNodeXPath("//ISBN", outputDocument);
		Node victim = getSingleNodeXPath("//ISBN", outputDocument);
        printNode(victim);
        String thisISBN = ((Element) source).getTextContent();
    	((Element) victim).setTextContent(thisISBN);
        printNode(victim);
	}

	// Idea: just get an item_id and set it to something bogus.
	private static void corruptRelatedItemSequenced() {
        Node victim = getSingleNodeXPath("//item_id", outputDocument);
        printNode(victim);
        String thisId = ((Element) victim).getTextContent();
    	((Element) victim).setTextContent(thisId+"321342009988");
        printNode(victim);
	}

	// Idea: select an <authors> element. Then take one of the <author_Versions> and 
	// duplicate it 10 times, each time changing the ID (so that we don't violate any other uniqueness constraints.)
	// What we end up with is 10 authors during this version!
	static void corruptAuthorsSequenced(){
        Node victim = getSingleNodeXPath("//authors", outputDocument);
        //printNode(victim);
        Node versionToCopy = getSingleNodeXPath(".//author_Version", victim);
        
        Node parent = versionToCopy.getParentNode();
        
        for (int i =1; i < 10; ++i){
        	Node newNode = versionToCopy.cloneNode(true);
        	
        	// Set id attribute
        	Node thisAuthor = getFirstElement(newNode);
        	String thisId = ((Element) thisAuthor).getAttribute("author_id");
        	((Element) thisAuthor).setAttribute("author_id", thisId+"321342"+i);
        	
        	parent.appendChild(newNode);
        }
        
        //printNode(victim);
    }
        
	static int rollDice(){
		return generator.nextInt(3)+1;
	}
	
	private static final void handleError(Throwable ex) {
	    System.out.println("tCorrputor: Error with DOM");
	 }
	
	public static void writeXmlFile(Document output, String filename) {

		try{
		FileOutputStream fos = new FileOutputStream(filename);
		// XERCES 1 or 2 additionnal classes.
		OutputFormat of = new OutputFormat("XML","ISO-8859-1",true);
		of.setIndent(1);
		of.setIndenting(true);
		XMLSerializer serializer = new XMLSerializer(fos,of);
		// As a DOM Serializer
		serializer.asDOMSerializer();
		serializer.serialize( output.getDocumentElement() );
		fos.close();
		} catch (Exception e){handleError(e);}
	}
	
	public static List<Element> findAllElementsByTagName(Element elem, String tagName) {
	    List<Element> ret = new LinkedList<Element>();
	    findAllElementsByTagName(elem, tagName, ret);
	    return ret;
	}
	
	  private static void findAllElementsByTagName(Element el, String tagName, List<Element> elementList) {

	    if (tagName.equals(el.getTagName())) {
	      elementList.add(el);
	    }
	    Element elem = getFirstElement(el);
	    while (elem != null) {
	      findAllElementsByTagName(elem, tagName, elementList);
	      elem = getNextElement(elem);
	    }
	  }
	  
	  public static Element getFirstElement(Node parent) {
		    Node n = parent.getFirstChild();
		    while (n != null && Node.ELEMENT_NODE != n.getNodeType()) {
		      n = n.getNextSibling();
		    }
		    if (n == null) {
		      return null;
		    }
		    return (Element) n;
		  }
	  
  public static Element getNextElement(Element el) {
    Node nd = el.getNextSibling();
    while (nd != null) {
      if (nd.getNodeType() == Node.ELEMENT_NODE) {
        return (Element) nd;
      }
      nd = nd.getNextSibling();
    }
    return null;
  }

private static Document copyDocument(Document d1){
		DocumentBuilderFactory factory;
		DocumentBuilder loader;
		Document d2 = null;
		try {
		      factory = DocumentBuilderFactory.newInstance();
		      loader  = factory.newDocumentBuilder();
		      d2 = loader.newDocument();
              d2.appendChild(d2.importNode((Node)d1.getDocumentElement(), true));
        }catch(Exception e){}
        return d2;

}

private static void printNode(Node node){
 try
    {
      // Set up the output transformer
      TransformerFactory transfac = TransformerFactory.newInstance();
      Transformer trans = transfac.newTransformer();
      trans.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
      trans.setOutputProperty(OutputKeys.INDENT, "yes");
      // Print the DOM node
      StringWriter sw = new StringWriter();
      StreamResult result = new StreamResult(sw);
      DOMSource source = new DOMSource(node);
      trans.transform(source, result);
      String xmlString = sw.toString();

      System.out.println(xmlString);
    }
    catch (TransformerException e)
    {
      e.printStackTrace();
    }
}

private static void printItem(Node n, String sep){
	
	String name = n.getNodeName();
	if (!(name.contains("item") || name.contains("author") || name.contains("publisher") || name.contains("related_item"))){
		
	} else {
		
		if (n.getNodeType() == Node.ELEMENT_NODE){
			System.out.print(sep + n.getNodeName() + ": ");
			Element e = (Element )n;
			NamedNodeMap nnm = e.getAttributes();
			for (int i=0; i< nnm.getLength(); ++i){
				System.out.print(nnm.item(i) + " ");
			}
			System.out.println("");
		}
	}

	Node child = n.getFirstChild();
	if (child != null){
		printItem(child, sep + "  ");
	}
	Node next = n.getNextSibling();
	if (next != null){
		printItem(next, sep);
	}
}

private static Node getSingleNodeXPath(String path, Object p) {
	try{
      NodeList e = (NodeList) xpath.evaluate(path, p, XPathConstants.NODESET);

      int i = e.getLength();
      int id = generator.nextInt(e.getLength());
      return (Node)e.item(id);
    } catch (Exception e){System.out.println(e);};
    return null;
}

private static NodeList getAllNodesXPath(String path, Object p) {
	try{
      NodeList e = (NodeList) xpath.evaluate(path, p, XPathConstants.NODESET);
      return e;
    } catch (Exception e){System.out.println(e);};
    return null;
}

private static String getTimeFromXPath(String path, Object p, int index) {
	try{
		path = "//@begin";
		NodeList e  = (NodeList) xpath.evaluate(path, (Document)p, XPathConstants.NODESET);
		return e.item(index).getTextContent();
    } catch (Exception e){System.out.println(e);};
    return null;
}

}
