#!/bin/bash

# Stephen W. Thomas
# Last Updated: Febrary 2013
#
# Run in current directory, i.e.,
# ./makeAll.sh
#
# This script descends into each benchmark, and calls the Makefile.
# The data is cleaned, created, validated, but not executed.
# The script descends into each benchmark in order. (See the docs.)
# It halts if any of the Makefiles fail.

function makeBenchmark {
    curDir=`pwd`
    echo ""
    echo "Executing the Makefile for $1"
    cd $1
    make clean
    make create
    make validate
    #make execute

    rc=$?
    if [[ $rc != 0 ]]; then
        echo "makeAll.sh failed for $1:"
        exit $rc
    fi
    cd $curDir
}

makeBenchmark 'benchmarks/DC-SD' 
makeBenchmark 'benchmarks/PSM' 
makeBenchmark 'benchmarks/tXBench' 
makeBenchmark 'benchmarks/tXSchema' 
makeBenchmark 'benchmarks/PSM-DB2' 
makeBenchmark 'benchmarks/tPSM' 
makeBenchmark 'benchmarks/tPSM-MaxMapped' 
makeBenchmark 'benchmarks/tPSM-MaxMapped-DB2' 
makeBenchmark 'benchmarks/tPSM-PerStmtMapped' 
makeBenchmark 'benchmarks/tPSM-PerStmtMapped-DB2' 


