----------------------------------------------------------------
-- Q9:
--   Return the ISBN of an item with id attribute value (I5)
-- Feature:
--   CALL procedure from function
----------------------------------------------------------------
CREATE PROCEDURE perstmt_proc_get_isbn_with_item_id(IN item_id_in CHARACTER(10))
  LANGUAGE SQL
    CREATE TEMPORARY TABLE temp_isbn AS
        (SELECT isbn, begin_time, end_time
           FROM item
           WHERE item_id = item_id_in;

CREATE FUNCTION perstmt_invoke_proc(item_id_in CHARACTER(10))
  RETURNS ROW (taupsm_result CHARACTER VARYING(20),
               begin_time DATE,
               end_time DATE)
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (taupsm_result CHARACTER VARYING(20),
                            begin_time DATE,
                            end_time DATE)
    CALL perstmt_proc_get_isbn_with_item_id(item_id_in);
    FOR tp AS
      SELECT * FROM temp_isbn
    DO
      INSERT INTO return_tbl VALUES tp;
    END FOR;
    RETURN return_tbl;
  END;

SELECT i.isbn,
    LAST_INSTANCE(i.begin_time, t.begin_time) AS begin_time,
    FIRST_INSTANCE(i.end_time, t.end_time) AS end_time
  FROM item i, perstmt_invoke_proc('I5') t
  WHERE t.taupsm_result = i.isbn AND
    LAST_INSTANCE(i.begin_time, t.begin_time) <
        FIRST_INSTANCE(i.end_time, t.end_time);

