----------------------------------------------------------------
-- Q7c:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   nested FETCHes
----------------------------------------------------------------
CREATE FUNCTION all_author_from_country(item_id_in CHARACTER(10),
                                        country_in CHARACTER(20),
                                        begin_time_in DATE,
                                        end_time_in DATE)
  RETURNS return_tbl ROW (taupsm_result CHARACTER(10),
                          begin_time DATE,
                          end_time DATE) ARRAY;
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
  DECLARE begin_time_var DATE;
  DECLARE end_time_var DATE;
  DECLARE country_name_var CHARACTER(20);
  DECLARE author_id_var CHARACTER(10);
  DECLARE begin_time_var2 DATE;
  DECLARE end_time_var2 DATE;
  DECLARE author_id_var2 CHARACTER(10);
  DECLARE item_id_var2 CHARACTER(10);
  CREATE TABLE TS (time_point DATE) AS (
    SELECT begin_time AS time_point FROM author
    UNION
    SELECT end_time AS time_point FROM author);
  CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time
                       AND NOT EXISTS(
                         SELECT time_point FROM TS
                         WHERE time_point > begin_time
                             AND time_point < end_time)
                       AND begin_time_in < ts2.time_point
                       AND ts1.time_point < end_time_in
                           ORDER BY begin_time);
  DECLARE author_cursor CURSOR FOR
      SELECT a.name_of_country, a.author_id, begin_time, end_time
          LAST_INSTANCE(
            LAST_INSTANCE(
                a.begin_time, begin_time_in),
              CP.begin_time) AS begin_time,
          FIRST_INSTANCE(
            FIRST_INSTANCE(
                a.end_time, end_time_in),
              CP.end_time) AS end_time
        FROM author a, CP
        WHERE 
            LAST_INSTANCE(
              LAST_INSTANCE(a.begin_time, begin_time_in),
                CP.begin_time) <
                    FIRST_INSTANCE(
                      FIRST_INSTANCE(a.end_time, end_time_in),
                      CP.end_time)
      ORDER BY CP.begin_time;
  DECLARE not_found CONDITION FOR SQLSTATE '02000';
  OPEN authro_cursor;
  FETCH author_cursor into country_name_var, author_id_var,
      begin_time_var, end_time_var;
  SET author_not_found = not_found;
  CREATE TABLE TS (time_point DATE) AS (
    SELECT begin_time AS time_point FROM item_author
    UNION
    SELECT end_time AS time_point FROM item_author);
  CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                        ts2.time_point AS end_time
                   FROM TS AS ts1, TS AS ts2
                   WHERE begin_time < end_time
                     AND NOT EXISTS(
                       SELECT time_point FROM TS
                       WHERE time_point > begin_time
                           AND time_point < end_time)
                     AND begin_time_in < ts2.time_point
                     AND ts1.time_point < end_time_in
                         ORDER BY begin_time);
  DECLARE item_author_cursor CURSOR FOR
      SELECT author_id, item_id,
          LAST_INSTANCE(
            LAST_INSTANCE(
                ia.begin_time, begin_time_in),
              CP.begin_time) AS begin_time,
          FIRST_INSTANCE(
            FIRST_INSTANCE(
                ia.end_time, end_time_in),
              CP.end_time) AS end_time
        FROM item_author ia, CP
        WHERE author_id = author_id_var AND item_id = item_id_in AND
          LAST_INSTANCE(
            LAST_INSTANCE(ia.begin_time, begin_time_in),
              CP.begin_time) <
                FIRST_INSTANCE(
                  FIRST_INSTANCE(i.end_time, end_time_in),
                      CP.end_time)
      ORDER BY CP.begin_time;
  DECLARE item_author_not_found BOOLEAN;
  REPEAT
    FETCH item_author_cursor into author_id_var2, item_id_var2,
        begin_time_var2, end_time_var2;
    SET item_author_not_found = not_found;
    IF (country_name_var <> country_in AND (NOT item_author_not_found))
    THEN
      BEGIN
        CLOSE author_cursor;
        CLOSE item_author_cursor;
        INSERT INTO result_tbl VALUES (FALSE, begin_time_var2, end_time_var2);
        return result_tbl;
      END;
    ELSE
      BEGIN
        FETCH author_cursor into country_name_var, author_id_var,
            begin_time_var, end_time_var;
        SET author_not_found = not_found;
    END IF;
    UNTIL item_author_not_found;
  END REPEAT;
  CLOSE author_cursor;
  CLOSE item_author_cursor;
  INSERT INTO result_tbl VALUES (TRUE, begin_time_var, end_time_var);
  RETURN result_tbl;
END;

SELECT i.*, LAST_INSTANCE((i.begin_time, t.begin_time) AS begin_time
    FIRST_INSTANCE(i.end_time, t.end_time) AS end_time)
FROM item i, all_author_from_country(item_id, 'Canada',
                                     i.begin_time, i.end_time) AS t
WHERE t.taupsm_result;

