----------------------------------------------------------------
-- This is without temporal closure. See q7.psStaged for
-- details on step 3.
-- Q7:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   WHILE statement
----------------------------------------------------------------
CREATE FUNCTION perstmt_all_author_from_country(item_id_in CHARACTER(10),
                                                country_in CHARACTER(20),
                                                begin_time_in DATE,
                                                end_time_in DATE)
  RETURNS ROW (taupsm_result BOOLEAN,
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (result BOOLEAN,
                            begin_time DATE,
                            end_time DATE) ARRAY;
    DECLARE total_count INT;
    DECLARE country_name CHARACTER(20);
    DECLARE tmp_begin_time DATE;
    DECLARE tmp_end_time DATE;

    CREATE TEMPORARY TABLE TS AS (
      SELECT begin_time AS time_point FROM author
      UNION
      SELECT end_time AS time_point FROM author
      UNION
      SELECT begin_time AS time_point FROM item_author
      UNION
      SELECT end_time AS time_point FROM item_author);
    CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time
                       AND NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time
                             AND time_point < end_time)
                       AND min_time < ts2.time_point
                       AND ts1.time_point < end_time_in
                           ORDER BY begin_time);

    DECLARE country_cursor CURSOR FOR
        SELECT a.name_of_country,
            LAST_INSTANCE(
              LAST_INSTANCE(
                LAST_INSTANCE(
                    i.begin_time, ia.begin_time),
                    begin_time_in),
                CP.begin_time) AS begin_time,
            FIRST_INSTANCE(
              FIRST_INSTANCE(
                FIRST_INSTANCE(
                    i.end_time, ia.end_time),
                    end_time_in),
                CP.end_time) AS end_time
          FROM author a, item_author ia, CP
          WHERE a.author_id = ia.author_id AND ia.item_id = item_id_in AND
            LAST_INSTANCE(
              LAST_INSTANCE(
                LAST_INSTANCE(i.begin_time, ia.begin_time), begin_time_in),
                  CP.begin_time) <
                    FIRST_INSTANCE(
                      FIRST_INSTANCE(
                        FIRST_INSTANCE(i.end_time, ia.end_time), end_time_in),
                        CP.end_time)
        ORDER BY CP.begin_time;
    for_loop_slicing:
    DECLARE country_not_found CONDITION FOR SQLSTATE '02000';
    DECLARE previous_time DATE;
    OPEN country_cursor;
    SET total_count = 0;
    FETCH country_cursor INTO country_name, tmp_begin_time, tmp_end_time;
    SET previous_time = tmp_begin_time;
    while1: WHILE DO
      IF SQLCODE <> 0
      THEN LEAVE;
      END IF;
      -- SET result = TRUE;
      INSERT INTO return_tbl VALUES (tmp_begin_time, tmp_end_time);
      IF (previous_time = tpm_begin_time)
      THEN BEGIN
        SET total_count = total_count + 1;
        IF (country_name <> country_in)
        THEN BEGIN
          -- SET result = FALSE;
          DELETE FROM return_tbl WHERE begin_time = tmp_begin_time;
        END
        ELSE BEGIN
          FETCH country_cursor INTO country_name;
          SET previous_time = tmp_begin_time;
        END IF;
      ELSE BEGIN
        IF total_count = 0 -- do ending stuff for this time period
        THEN BEGIN
          -- SET result = FALSE;
          DELETE FROM return_tbl WHERE begin_time = tmp_begin_time;
          SET previous_time = tmp_begin_time;
          SET total_count = 0;  -- reset rest of variables
        END IF;
      END IF;
    END WHILE;
    CLOSE country_cursor;
    -- RETURN result;
    RETURN return_tbl;
  END;

SELECT i.*,
    LAST_INSTANCE(i.begin_time, t.begin_time),
    FIRST_INSTANCE(i.end_time, t.end_time)
  FROM item i, perstmt_all_author_from_country(i.item_id, 'Canada',
                                               i.begin_time, i.end_time) t
  WHERE
    t.result AND
    LAST_INSTANCE(i.begin_time, t.begin_time) <
        FIRST_INSTANCE(i.end_time, t.end_time);
