----------------------------------------------------------------
-- Q6:
--   Return item information where some authors are from
--   certain country (Canada).
-- Feature:
--   CASE statement
----------------------------------------------------------------
CREATE FUNCTION perstmt_is_from_country(country_name CHARACTER(20),
                                        country CHARACTER(20))
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    CASE WHEN (country_name = country)
    THEN
      RETURN TRUE;
    ELSE
      RETURN FALSE;
  END;

SELECT DISTINCT i.*,
        LAST_INSTANCE(
             LAST_INSTANCE(i.begin_time, a.begin_time),
             ia.begin_time) AS begin_time,
        FIRST_INSTANCE(
            FIRST_INSTANCE(i.end_time, a.end_time),
            ia.end_time) AS end_time
  FROM item i, author a, item_author ia,
  WHERE i.id = ia.item_id AND a.author_id = ia.author_id AND
    perstmt_is_from_country(a.name_of_country, 'Canada') AND
        LAST_INSTANCE(
             LAST_INSTANCE(i.begin_time, a.begin_time),
             ia.begin_time) <
        FIRST_INSTANCE(
                FIRST_INSTANCE(i.end_time, a.end_time),
                ia.end_time);

