----------------------------------------------------------------
-- Q5: 
--   List the last name of the authors with a matching id of
--   value (I3).
-- Feature:
--   Function in the SELECT clause
----------------------------------------------------------------
CREATE FUNCTION perstmt_get_author_name(item_id_in CHARACTER(10),
                                        begin_time_in DATE,
                                        end_time_in DATE)
  RETURNS ROW (taupsm_result CHARACTER(50),
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (taupsm_result CHARACTER(50),
                            begin_time DATE,
                            end_time DATE) ARRAY;
    INSERT INTO return_tbl;
        SELECT a.last_name,
            LAST_INSTANCE(
                LAST_INSTANCE(a.begin_time, ia.begin_time), begin_time_in),
            FIRST_INSTANCE(
                FIRST_INSTANCE(a.end_time, ia.end_time), end_time_in),
          FROM author a, item_author ia
          WHERE ia.author_id = a.author_id AND
              ia.item_id = item_id_in AND
              LAST_INSTANCE(
                  LAST_INSTANCE(a.begin_time, ia.begin_time), begin_time_in) <
                      FIRST_INSTANCE(
                          FIRST_INSTANCE(a.end_time, ia.end_time), end_time_in);
    RETURN return_tbl;
  END;

SELECT t.taupsm_result,
    LAST_INSTANCE(i.begin_time, t.begin_time) AS begin_time,
    FIRST_INSTANCE(i.end_time, t.end_time) AS end_time
  FROM item i,
    perstmt_get_author_name('I3', i.begin_time, i.end_time)  
  WHERE i.item_id = 'I3' AND
      LAST_INSTANCE(i.begin_time, t.begin_time) <
          FIRST_INSTANCE(i.end_time, t.end_time);
