----------------------------------------------------------------
-- Q3:
--   Group items released in a certain year (1990),
--   by publisher name and calculated the total number of
--   items for each group.
-- Feature:
--   RETURN with SELECT single row
----------------------------------------------------------------
CREATE FUNCTION perstmt_get_release_date(item_id_in CHARACTER(10),
                                         begin_time_in DATE, end_time_in DATE)
  RETURNS ROW (taupsm_result DATE,
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (taupsm_result DATE
                            begin_time DATE,
                            end_time DATE) ARRAY;
    INSERT INTO return_tbl
        SELECT i.date_of_release,
            LAST_INSTANCE(i.begin_time, begin_time_in) AS begin_time,
            FIRST_INSTANCE(i.end_time, end_time_in) AS end_time 
          FROM item i
          WHERE i.item_id = item_id_in AND
              LAST_INSTANCE(i.begin_time, begin_time_in) <
                  FIRST_INSTANCE(i.end_time, end_time_in);
    RETURN return_tbl;
  END;

SELECT p.name, SUM(i.quantity_in_stock),
    LAST_INSTANCE(
            LAST_INSTANCE(
                LAST_INSTANCE(i.begin_time, p.begin_time),
                ip.begin_time),
            t.begin_time) <
          FIRST_INSTANCE(
              FIRST_INSTANCE(
                  FIRST_INSTANCE(i.end_time, p.end_time),
                  ip.end_time),
              t.end_time) AS end_time
  FROM item i, publisher p, item_publisher ip,
    perstmt_get_release_date(i.item_id,
     LAST_INSTANCE(
        LAST_INSTANCE(
            i.begin_time, p.begin_time), ip.begin_time) AS begin_time,
    FIRST_INSTANCE(
        FIRST_INSTANCE(
            i.end_time, p.end_time), ip.end_time))) t
  WHERE i.item_id = ip.item_id AND ip.publisher_id = p.publisher_id AND
    t.taupsm_result BETWEEN '1990-01-01' AND '1991-01-01' AND
    LAST_INSTANCE(LAST_INSTANCE(i.begin_time, p.begin_time), t.begin_time) <
      FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, p.end_time), t.end_time)
  GROUP BY p.name;

