----------------------------------------------------------------
-- Q2:
--   Find the title of the item which has matching author
--   first name (Ben).
-- Feature:
--   SET with SELECT single row
----------------------------------------------------------------
CREATE FUNCTION perstmt_get_author_name(min_time DATE, max_time DATE,
					author_id_in CHARACTER(10))
  RETURNS ROW (taupsm_result CHARACTER(50),
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE get_author_names_return_tbl ROW(taupsm_result CHARACTER(50),
                              begin_time DATE, 
			      end_time DATE) ARRAY;
    INSERT INTO get_author_names_return_table
	  INSERT INTO db2_ps_get_author_name_return_tbl
      SELECT a.first_name, ai.author_id, 
          a.begin_time,
          a.end_time 
        FROM author a, author_id_tbl ai
        WHERE a.author_id = ai.author_id AND
          a.begin_time $REL1 min_time AND
          a.begin_time $REL2 max_time;
END;

INSERT INTO author_id_tbl SELECT DISTINCT author_id FROM item_author

CALL db2_ps_proc_get_author_name($TIME_PERIOD)


SELECT i.title,
    LAST_INSTANCE(LAST_INSTANCE(i.begin_time, ia.begin_time), t.begin_time) AS begin_time,
    FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, ia.end_time), t.end_time)AS end_time 
  FROM item i, item_author ia, perstmt_get_author_name(
                            LAST_INSTANCE(i.begin_time, ia.begin_time),
                            FIRST_INSTANCE(i.end_time, ia.end_time), ia.author_id,) t
  WHERE i.id = ia.item_id AND
    t.taupsm_result = 'Bai' AND
    t.author_id = ia.author_id AND
    LAST_INSTANCE(LAST_INSTANCE(i.begin_time, ia.begin_time), t.begin_time) <
      FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, ia.end_time), t.end_time)


