----------------------------------------------------------------
-- Q20:
--   Retrieve the item title whose size (length*width*height)
--   is bigger than certain number (500000).
-- Feature:
--   ASSIGNMENT statement
----------------------------------------------------------------
CREATE FUNCTION perstmt_sizeof_item(length NUMBER, width NUMBER, height NUMBER,
                                    begin_time_in DATE,
                                    end_time_in DATE)
  RETURNS ROW (taupsm_result NUMBER,
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (taupsm_result NUMBER,
                            begin_time DATE,
                            end_time DATE) ARRAY;
    DECLARE size NUMBER;
    SET size = length * width * height;
    INSERT INTO return_tbl VALUES (size, begin_time_in, end_time_in);
    RETURN return_tbl;
  END;

SELECT i.title,
    LAST_INSTANCE(i.begin_time, t.begin_time) AS begin_time,
    FIRST_INSTANCE(i.end_time, t.end_time) AS end_time
  FROM item i, perstmt_sizeof_item(i.length, i.width, i.height,
                                   i.begin_time, i.end_time) t
  WHERE t.taupsm_result > 500000 AND
    LAST_INSTANCE(i.begin_time, t.begin_time) <
        FIRST_INSTANCE(i.end_time, t.end_time);

