----------------------------------------------------------------
-- Q2:
--   Find the title of the item which has matching author
--   first name (Ben).
-- Feature:
--   SET with SELECT single row
----------------------------------------------------------------
CREATE FUNCTION perstmt_get_author_name(author_id_in CHARACTER(10),
                                        begin_time_in DATE,
                                        end_time_in DATE)
  RETURNS ROW (taupsm_result CHARACTER(50),
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    -- because we can get a time varying result
    DECLARE result_names ROW (taupsm_result CHARACTER(50),
                              begin_time DATE,
                              end_time DATE) ARRAY;
    INSERT INTO result_names
      SELECT a.first_name,
          LAST_INSTANCE(a.begin_time, begin_time_in) AS begin_time,
          FIRST_INSTANCE(a.end_time, end_time_in) AS end_time 
        FROM author a
        WHERE a.author_id = author_id_in AND
          LAST_INSTANCE(a.begin_time, begin_time_in) <
            FIRST_INSTANCE(a.end_time, end_time_in);
    RETURN result_names;
  END;

SELECT i.title,
    LAST_INSTANCE(
        LAST_INSTANCE(
            i.begin_time, ia.begin_time),
            t.begin_time) AS begin_time,
    FIRST_INSTANCE(
        FIRST_INSTANCE(
            i.end_time, ia.end_time),
            t.end_time) AS end_time
  FROM item i, item_author ia,
    perstmt_get_author_name(ia.author_id,
                            LAST_INSTANCE(i.begin_time, ia.begin_time),
                            FIRST_INSTANCE(i.end_time, ia.end_time)) t
  WHERE i.id = ia.item_id AND
    t.taupsm_result = 'Ben' AND
    LAST_INSTANCE(LAST_INSTANCE(i.begin_time, ia.begin_time), t.begin_time) <
      FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, ia.end_time), t.end_time)

