-- We do nested slicing.
----------------------------------------------------------------
-- Q17b:
--   Return the first n ids of the items whose descriptions
--   contain a certain word ("hockey") and for which the number
--   of pages is less than 500 if at least one author is Canadian.
--   (n is an input parameter)
--   Also return the relevant date for each id.
--   If all n are evaluated, results will be sorted by id.
-- Feature:
--   1. many time-varying variables
--   2. two time-varying tables
--   3. nested loop
--   4. multiple FETCHes in a loop
--   5. multiple SET of variables
--   6. a FETCH in the ELSE but not in the THEN part
--   7. function call
--   8. LEAVE statement
--   9. Both CURSOR and FOR 
--  10. INSERT and ELSE statement on arrays
--  11. procedure call that returns a time-varying result
----------------------------------------------------------------
CREATE FUNCTION perstmt_is_small_book(in_item_id INT)
  RETURNS ROW (result BOOLEAN, from_time DATE, to_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE LOCAL TEMPORARY TABLE psm_result  (result BOOL,
                              begin_time DATE,
                              end_time DATE);
    CREATE TEMPORARY TABLE item_TS0 AS (
          SELECT begin_time AS time_point FROM item
          UNION
          SELECT end_time AS time_point FROM item);

    CREATE VIEW item_CP0
       AS (SELECT ts1.time_point AS begin_date,
                          ts2.time_point AS end_date
           FROM item_TS0 AS ts1, item_TS0 AS ts2
           WHERE begin_time < end_time AND
           NOT EXISTS(SELECT time_point FROM item_TS0
                      WHERE time_point > begin_time AND
                             time_point < end_time)
                      ORDER BY begin_time);
    -- orig: SET num_pages = SELECT...
    FOR num_pages AS
       SELECT i.number_of_pages,
              item_CP0.begin_date, item_CP0.end_date
       FROM item_CP0, item i
       WHERE i.id = in_item_id
              AND i.begin_date <= item_CP0.begin_date
              AND item_CP0.end_date <= i.end_date
    DO
       INSERT INTO psm_result
       VALUES (num_pages.number_of_pages <= 500), num_pages.begin_time,
                  num_pages.end_time)
    END FOR;
    RETURN psm_result;
  END


CREATE PROCEDURE perstmt_has_author_canadian(in_item_id INT IN,
                          has_canadian ROW (result_has_canadian BOOLEAN,
                                            begin_time DATE,
                                            end_time DATE) ARRAY OUT)
  READS SQL DATA
  LANGUAGE SQL
  BEGIN 
    DECLARE LOCAL TEMPORARY TABLE psm_has_canadian (result_has_canadian BOOLEAN,
                                            begin_time DATE,
                                            end_time DATE);
    CREATE TEMPORARY TABLE author_TS AS (
          SELECT begin_time AS time_point FROM author
          UNION
          SELECT end_time AS time_point FROM author
          UNION
          SELECT begin_time AS time_point FROM item_author
          UNION
          SELECT end_time AS time_point FROM item_author);

    CREATE VIEW author_CP
       AS (SELECT ts1.time_point AS begin_date,
                          ts2.time_point AS end_date
           FROM author_TS AS ts1, author_TS AS ts2
           WHERE begin_time < end_time AND
           NOT EXISTS(SELECT time_point FROM author_TS
                      WHERE time_point > begin_time AND
                             time_point < end_time)
                      ORDER BY begin_time);
    INSERT INTO psm_has_canadian
      AS SELECT TRUE, author_CP.begin_date, author_CP.end_date
         FROM author_CP, item_author ia, author a
         WHERE ia.item_id = in_item_id AND a.author_id = ia.author_id
             AND a.name_of_country = 'Canada'
             AND ia.begin_date <= author_CP.begin_date
             AND author_CP.end_date <= ia.end_date
             AND a.begin_date <= author_CP.begin_date
             AND author_CP.end_date <= a.end_date;
    SET has_canadian = psm_has_canadian;
  END



CREATE FUNCTION perstmt_get_first_n_items_about_hockey(first_n INT)
   RETURNS ROW (first_n INT, begin_date DATE, end_date DATE) ARRAY
   READS SQL DATA
   LANGUAGE SQL
   BEGIN  -- block 1
       DECLARE taupsm_RETURN_tbl (first_n INT, begin_date DATE, end_date DATE) ARRAY;
    -- needed for later sorting
       DECLARE temp_item_id_tbl ROW (taupsm_item_id INT,
                                     sometime DATE) ARRAY;
       DECLARE return_item_id_tbl ROW (taupsm_item_id INT,
                                       sometime DATE,
                                       begin_date DATE,
                                       end_date DATE) ARRAY;
       DECLARE temp_item_id CHARACTER(10);
       DECLARE temp_when_is_available DATE;
       DECLARE temp_date_of_release DATE;
       DECLARE relevant_date DATE;
       DECLARE has_canadian BOOLEAN;
       DECLARE count INT;

       SET count = 0;
    CREATE TEMPORARY TABLE item_TS AS (
          SELECT begin_time AS time_point FROM item
          UNION
          SELECT end_time AS time_point FROM item);

    CREATE VIEW item_CP
       AS (SELECT ts1.time_point AS begin_date,
                          ts2.time_point AS end_date
           FROM item_TS AS ts1, item_TS AS ts2
           WHERE begin_time < end_time AND
           NOT EXISTS(SELECT time_point FROM item_TS
                      WHERE time_point > begin_date AND
                             time_point < end_date)
                      ORDER BY begin_time);


       DECLARE CURSOR all_items_cur FOR
       SELECT i.id, i.when_is_available, i.date_of_release,
      	      item_CP.begin_date, item_CP.end_date
       FROM item_CP, item i
       WHERE i.description LIKE '%hockey%'
              AND i.begin_date <= item_CP.begin_date
              AND item_CP.end_date <= i.end_date
       ORDER BY begin_date;
       DECLARE all_items_curr_begin DATE;
       DECLARE all_items_curr_end DATE;

       DECLARE hockey_not_found CONDITION FOR SQLSTATE '02000';
       DECLARE hockey_not_found_boolean BOOLEAN;

       OPEN all_items_cur;

       DECLARE min_scope1 DATE;
       DECLARE max_scope1 DATE;
       DECLARE all_items_cur_COUNT INT;

       REPEAT -- block 2
       FETCH all_items_cur INTO
            temp_item_id, temp_when_is_available, temp_date_of_release,
    	    min_scope1, max_scope1;

            SET all_items_cur_COUNT = 0;

            while_loop: WHILE NOT(hockey_not_found) DO  -- block 3

                 CALL perstmt_has_author_canadian(temp_item_id, has_canadian);
             CREATE TEMPORARY TABLE has_canadian_TS AS (
                 SELECT begin_time AS time_point FROM has_canadian
                 UNION
                 SELECT end_time AS time_point FROM has_canadian);

             CREATE VIEW has_canadian_CP
                AS (SELECT ts1.time_point AS begin_date,
                           ts2.time_point AS end_date
                    FROM has_canadian_TS AS ts1, has_canadian_TS AS ts2
                    WHERE begin_time < end_time AND
                        NOT EXISTS(SELECT time_point FROM item_TS
                                   WHERE time_point > begin_date AND
                                           time_point < end_date)
                                   ORDER BY begin_time);

                 FOR has_canadian_curr AS
                 SELECT has_canadian, 
                        has_canadian_CP.begin_date, has_canadian_CP.end_date
                 FROM has_canadian_CP, has_canadian
                 WHERE begin_date <= has_canadian_CP.begin_date
                      AND has_canadian_CP.end_date <= end_date
          	 ORDER BY begin_date
                 DO BEGIN  -- block 4
                    SET is_small_book_tbl = is_small_book(temp_item_id);

                    CREATE TEMPORARY TABLE is_small_book_TS AS (
                      SELECT begin_time AS time_point FROM is_small_book_tbl
                      UNION
                      SELECT end_time AS time_point FROM is_small_book_tbl);
                    CREATE VIEW is_small_book_CP
                      AS (SELECT ts1.time_point AS begin_date,
                            ts2.time_point AS end_date
                       FROM is_small_book_TS AS ts1, is_small_book_TS AS ts2
                       WHERE begin_time < end_time AND
                             NOT EXISTS(SELECT time_point FROM item_TS
                                        WHERE time_point > begin_date AND
                                          time_point < end_date)
                       ORDER BY begin_time);

                   FOR is_small_book_curr AS
                   SELECT is_small_book,
                          is_small_book_CP.begin_date,
                          is_small_book_CP.end_date
                   FROM is_small_book_CP, is_small_book_tbl
                   WHERE begin_date <= is_small_book_CP.begin_date
                        AND is_small_book_CP.end_date <= end_date
                   ORDER BY begin_date
                   DO BEGIN  -- block 5
                   IF (has_canadian_curr.has_canadian AND is_small_book_curr.is_small_book)
                   THEN   ---block 6
                       IF (count % 2 = 0)
                       THEN
                           SET relevant_date = temp_when_is_available;
                       ELSE
                           SET relevant_date = temp_date_of_release;
                       END IF;
                       INSERT INTO temp_item_id_tbl VALUES (
                                         temp_all_items.id, relevant_date);
                       SET count = count + 1;
                       IF (count >= first_n)
                       THEN    -- block 7

                           FOR temp_item_id_order_curr AS
                           SELECT temp_item_id_order
                           FROM temp_item_id_order_tbl
                 	   ORDER BY taupsm_item_id
                           DO  -- block 8

                               INSERT INTO return_item_id_tbl
                	       VALUES (temp_item_id_order.taupsm_item_id,
 		                       temp_item_id_order.sometime,
                                       is_small_book_curr.begin_date,
                                       is_small_book_curr.end_date);
                           END FOR;  -- block 8
			   LEAVE while_loop;
                       ELSE  -- block 7 end; block 7
	                   FETCH all_items_cur INTO
                                temp_item_id, temp_when_is_available,
                                temp_date_of_release,
                 	        all_items_curr_begin_date,
                 	        all_items_curr_end_date;

                           IF hockey_not_true
                           THEN
                                SET hockey_not_found_boolean = True;
                           ELSE ---block 8
                                IF (all_items_curr_begin_date > min_scope1); -- next time period
             		        THEN -- block 8
				     FETCH PRIOR all_items_curr;
     	                             SET hockey_not_found_boolean = True;
                                ELSE
                                     SET all_items_curr_COUNT =
                                            all_items_curr_COUNT + 1;
                                END IF
                           END IF;  -- block 8
                       END IF;  -- block 7 end, block 6 end
                  END IF;  --block 6 end

              FETCH PRIOR all_item_cur_COUNT all_item_cur_COUNT;
                  
              END; -- FOR is_small_book_curr, block 5
          END; -- FOR has_canadian_curr, block 4
    END WHILE;  -- end block 3 WHILE

    FOR return_item_id_tbl_curr AS
       SELECT * FROM return_item_id_tbl
    DO  -- block 3
      INSERT INTO taupsm_RETURN_tbl
      VALUES (return_item_id_tbl_curr.taupsm_item_id,
              return_item_id_tbl_curr.sometime,
              return_item_id_tbl_curr.begin_date,
              return_item_id_tbl_curr.end_date);
    END FOR;  -- end block 3 FOR

    -- reset variables changed in loop
    DELETE * FROM temp_item_id;  -- reset this ROW ARRAY variable

    SET COUNT = 0;

    REPEAT   -- block 3
        SET old_min_scope1 = min_scope1;
        FETCH all_items_cur INTO
             temp_item_id, temp_when_is_available, temp_date_of_release
      	     min_scope1, max_scope1;

        SET hockey_not_found_boolean = hockey_not_found;

        IF NOT(hockey_not_found_boolean)
        THEN
              FETCH PRIOR all_items_cur;
        END;

    UNTIL hockey_not_found OR min_scope1 > old_min_scope1; -- next time period
    END REPEAT; -- end block 3
  END REPEAT; -- end block 2
    CLOSE all_items_cur;
    RETURN taupsm_RETURN_tbl;
   END;  block 1

SELECT * FROM get_first_n_items_about_hockey(10);

