----------------------------------------------------------------
-- Q17:
--   Return the first id of the items whose descriptions contain
--   a certain word ("hockey").
-- Feature:
--   LEAVE statement
----------------------------------------------------------------
-- optimization 16: adding the begin and end scopes
CREATE FUNCTION perstmt_get_first_item_about_hockey()
  RETURNS return_tbl ROW (taupsm_result CHARACTER(10),
                          begin_time DATE,
                          end_time DATE) ARRAY;
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_id_var CHARACTER(10);
    DECLARE LOCAL TEMPORARY TABLE psm_return_id (return_id CHARACTER(10),
                                                 begin_time DATE,
                                                 end_time DATE);
    CREATE TEMPORARY TABLE TS AS (
      SELECT begin_time AS time_point FROM temp_item
      UNION
      SELECT end_time AS time_point FROM temp_item);
    CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time
                       AND NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time
                             AND time_point < end_time)
                       AND begin_time_in < ts2.time_point
                       AND ts1.time_point < end_time_in
                           ORDER BY begin_time);
    for_loop_slicing:
    FOR temp_items AS SELECT * FROM CP
    DO
      for_loop_inner:
      FOR all_items AS
        SELECT title, begin_time, end_time 
        FROM item i
          WHERE i.description LIKE '%hockey%'
      DO
        SET return_id_var = all_items.item_id;
        LEAVE for_loop_inner;
      END FOR; -- for_loop_inner
    INSERT INTO psm_return_id VALUES (return_id_var,
                                      CP.begin_time,
                                      CP.end_time);
    END FOR; -- for_loop_slicing
    RETURN psm_return_id;
  END;

SELECT i.id, LAST_INSTANCE((i.begin_time, t.begin_time) AS begin_time
    FIRST_INSTANCE(i.end_time, t.end_time) AS end_time)
  FROM item i, perstmt_get_first_item_about_hockey() t
  WHERE i.item_id = t.taupsm_result;
