----------------------------------------------------------------
-- Q14:
--   Return the names of publishers who publish books between
--   a period of time from 1990-01-01 to 1991-01-01 but
--   do not have FAX number.
-- Feature:
--   Local cursor declaration
--   FETCH, OPEN, and CLOSE statements
----------------------------------------------------------------
CREATE FUNCTION perstmt_is_released_in_period(publisher_id_in CHARACTER(10),
                                              from_date_in DATE,
                                              to_date_in DATE,
                                              begin_time_in DATE,
                                              end_time_in DATE)
  RETURNS ROW (begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (begin_time DATE,
                            end_time DATE) ARRAY;
    DECLARE var_publisher_id CHARACTER(10);
    DECLARE var_begin_time DATE;
    DECLARE var_end_time DATE;
    DECLARE SQLCODE INTEGER DEFAULT 0;
    DECLARE item_cursor CURSOR FOR
        SELECT id, LAST_INSTANCE(i.begin_time, ip.begin_time) AS begin_time,
            FIRST_INSTANCE(i.end_time, ip.end_time) AS end_time
          FROM item i, item_publisher ip
          WHERE i.item_id = ip.item_id AND
              ip.publisher_id = publisher_id_in AND
              i.date_of_release BETWEEN from_date AND to_date AND
              LAST_INSTANCE(i.begin_time, ip.begin_time) <
                  FIRST_INSTANCE(i.end_time, ip.end_time) AND
              LAST_INSTANCE(i.begin_time, ip.begin_time) <= begin_time_in AND
              begin_time_in < FIRST_INSTANCE(i.end_time, ip.end_time);
    OPEN item_cursor;
    FETCH item_cursor INTO var_begin_time, var_end_time;
    WHILE SQLCODE = 0 DO
      INSERT INTO return_tbl VALUES(var_begin_time, var_end_time);
      FETCH item_cursor INTO var_begin_time, var_end_time;
    END WHILE;
    CLOSE item_cursor;

    RETURN return_tbl;
  END;

SELECT p.name,
    LAST_INSTANCE(p.begin_time, t.begin_time) AS begin_time,
    FIRST_INSTANCE(p.end_time, t.end_time) AS end_time
  FROM publisher p,
    perstmt_is_released_in_period(p.publisher_id,
                                  '1990-01-01', '1991-01-01',
                                  p.begin_time, p.end_time) t
  WHERE p.fax_number IS NULL AND
    LAST_INSTANCE(p.begin_time, t.begin_time) <
        FIRST_INSTANCE(p.end_time, t.end_time);
