-----------------------------------------------------------------
-- Q10:
--   List the item titles ordered alphabetically by publisher
--   name, with release date within a certain time period
--   (from 1990-01-01 to 1995-01-01)
-- Feature:
--   IF without CURSOR
-----------------------------------------------------------------
CREATE FUNCTION perstmt_item_of_90s(rd DATE, min_time DATE, max_time DATE)
  RETURNS ROW (taupsm_result BOOLEAN,
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
  DECLARE return_tbl ROW (taupsm_result BOOLEAN,
                          begin_time DATE,
                          end_time DATE) ARRAY;
  -- to slice period of (min_time, max_time) with "item"
  CREATE TEMPORARY TABLE TS AS (
    SELECT begin_time AS time_point FROM item WHERE begin_time >= min_time
    UNION
    SELECT end_time AS time_point FROM item WHERE end_time <= );
  CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

  FOR result_CP AS
      SELECT begin_time, end_time FROM CP
    IF (rd >= '1990-01-01') AND (rd < '1995-01-01')
    THEN
      INSERT INTO return_tbl VALUES (TRUE, result_CP.begin_time,
                                     result_CP.end_time);
    ELSE
      INSERT INTO return_tbl VALUES (FALSE, result_CP.begin_time,
                                     result_CP.end_time);
    END IF;
  RETURN return_tbl;
END;

SELECT i.title, p.name,
    LAST_INSTANCE(
        LAST_INSTANCE(
            LAST_INSTANCE(p.begin_time, i.begin_time)), ip.begin_time),
        t.begin_time) AS begin_time,
    FIRST_INSTANCE(
        FIRST_INSTANCE(
            FIRST_INSTANCE(p.end_time, i.end_time)), ip.end_time),
        t.end_time) AS end_time
  FROM publisher p, item i, item_publisher ip
    perstmt_item_of_90s(
        i.date_of_release,
        LAST_INSTANCE(LAST_INSTANCE(p.begin_time, i.begin_time),
                      ip.begin_time),
        FIRST_INSTANCE(FIRST_INSTANCE(p.end_time, i.end_time),
                       ip.end_time))) t
  WHERE i.id = ip.item_id AND
    ip.publisher_id = p.publisher_id AND
    t.taupsm_result AND
    LAST_INSTANCE(
        LAST_INSTANCE(
            LAST_INSTANCE(p.begin_time, i.begin_time)), ip.begin_time),
        t.begin_time) <
      FIRST_INSTANCE(
          FIRST_INSTANCE(
              FIRST_INSTANCE(p.end_time, i.end_time)), ip.end_time),
          t.end_time)
  ORDER BY p.name

