-----------------------------------------------------------------
-- Q10:
--   List the item titles ordered alphabetically by publisher
--   name, with release date within a certain time period
--   (from 1990-01-01 to 1995-01-01)
-- Feature:
--   IF without CURSOR
-----------------------------------------------------------------
CREATE FUNCTION perstmt_item_of_90s(release_date_in DATE)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    IF (release_date_in >= '1990-01-01') AND (release_date_in < '1995-01-01')
    THEN RETURN TRUE;
    ELSE RETURN FALSE;
    END IF;
END;

SELECT i.title, p.name,
    LAST_INSTANCE(
        LAST_INSTANCE(
            LAST_INSTANCE(p.begin_time, i.begin_time)), ip.begin_time),
        t.begin_time) AS begin_time,
    FIRST_INSTANCE(
        FIRST_INSTANCE(
            FIRST_INSTANCE(p.end_time, i.end_time)), ip.end_time),
        t.end_time) AS end_time
  FROM publisher p, item i, item_publisher ip
  WHERE i.item_id = ip.item_id AND
    ip.publisher_id = p.publisher_id AND
    perstmt_item_of_90s(i.date_of_release) AND
    LAST_INSTANCE(
        LAST_INSTANCE(p.begin_time, i.begin_time)), ip.begin_time) <
    FIRST_INSTANCE(
        FIRST_INSTANCE(p.end_time, i.end_time)), ip.end_time)
  ORDER BY p.name

