----------------------------------------------------------------
-- Q8:
--   Return the publisher of an item with id attribute
--   value (I4).
-- Feature:
--   Loop name with FOR statement
----------------------------------------------------------------
-- init
CREATE TABLE db2_ps_get_publisher_id_by_item_id_return_tbl (
     taupsm_result CHARACTER(10),
     begin_time DATE,
     end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_get_publisher_id_by_item_id(
    IN item_id_in CHARACTER(10),
    IN min_time DATE, IN max_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
    FOR related AS
      SELECT i.id, ip.publisher_id,
          LAST_INSTANCE(i.begin_time, ip.begin_time) AS begin_time,
          FIRST_INSTANCE(i.end_time, ip.end_time) AS end_time
        FROM item i, item_publisher ip
        WHERE i.id = ip.item_id AND
          LAST_INSTANCE(i.begin_time, ip.begin_time)  <
            FIRST_INSTANCE(i.end_time, ip.end_time) AND
          LAST_INSTANCE(i.begin_time, ip.begin_time) $REL1 min_time AND
          LAST_INSTANCE(i.begin_time, ip.begin_time) $REL2 max_time
    DO
      IF (related.id = item_id_in)
        THEN
            INSERT INTO db2_ps_get_publisher_id_by_item_id_return_tbl VALUES (
                related.publisher_id,
                related.begin_time,
                related.end_time);
      END IF;
    END FOR;
END
-- end

-- sql
CALL db2_ps_proc_get_publisher_id_by_item_id(CAST('I100' AS CHARACTER(10)),
                                             $TIME_PERIOD)
-- end

-- sql
SELECT p.*,
    LAST_INSTANCE(p.begin_time, t.begin_time),
    FIRST_INSTANCE(p.end_time, t.end_time)
  FROM publisher p, db2_ps_get_publisher_id_by_item_id_return_tbl t
--    TABLE(db2_ps_get_publisher_id_by_item_id(CAST('I4' AS CHARACTER(10)),
--                                             p.begin_time, p.end_time)) t
  WHERE p.publisher_id = t.taupsm_result AND
    LAST_INSTANCE(p.begin_time, t.begin_time) <
        FIRST_INSTANCE(p.end_time, t.end_time)
-- end


