----------------------------------------------------------------
-- Q6:
--   Return item information where some authors are from
--   certain country (Canada).
-- Feature:
--   CASE statement
----------------------------------------------------------------
-- init
CREATE TABLE all_name_of_country_tbl(
    name_of_country VARCHAR(50),
    begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE db2_ps_is_from_country_return_tbl(
    taupsm_result INT,
    country_name VARCHAR(50),
    begin_time DATE, end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_is_from_country(
    IN country_in VARCHAR(50),
    IN min_time DATE, IN max_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  DECLARE taupsm_result INT;
  FOR all_name_of_country_cur AS
      SELECT name_of_country, begin_time, end_time
        FROM all_name_of_country_tbl
        WHERE begin_time $REL1 min_time AND
          begin_time $REL2 max_time AND
	  begin_time < end_time
    DO
    IF (all_name_of_country_cur.name_of_country = country_in)
      THEN
        SET taupsm_result = 1;
      ELSE
        SET taupsm_result = 0;
    END IF;
      INSERT INTO db2_ps_is_from_country_return_tbl VALUES (
          taupsm_result,
          all_name_of_country_cur.name_of_country,
          all_name_of_country_cur.begin_time,
          all_name_of_country_cur.end_time);
  END FOR;
END
-- end

-- sql
INSERT INTO all_name_of_country_tbl
    SELECT DISTINCT name_of_country, begin_time, end_time FROM author
-- end

-- sql
CALL db2_ps_proc_is_from_country(CAST('Canada' AS VARCHAR(50)),
                                 $TIME_PERIOD)
-- end

-- sql
SELECT DISTINCT i.*,
    LAST_INSTANCE(
        LAST_INSTANCE(
             LAST_INSTANCE(i.begin_time, a.begin_time),
             ia.begin_time),
        t.begin_time),
    FIRST_INSTANCE(
        FIRST_INSTANCE(
            FIRST_INSTANCE(i.end_time, a.end_time),
            ia.end_time),
        t.end_time)
  FROM item i, author a, item_author ia, db2_ps_is_from_country_return_tbl t
--  TABLE (
--    db2_ps_is_from_country(
--        a.name_of_country,
--        CAST('Canada' AS VARCHAR(50)),
--        LAST_INSTANCE(LAST_INSTANCE(i.begin_time, a.begin_time), ia.begin_time),
--        FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, a.end_time), ia.end_time))) t
  WHERE i.id = ia.item_id AND a.author_id = ia.author_id AND
    t.taupsm_result = 1 AND
    t.country_name = a.name_of_country AND
    LAST_INSTANCE(
        LAST_INSTANCE(
             LAST_INSTANCE(i.begin_time, a.begin_time),
             ia.begin_time),
        t.begin_time) <
        FIRST_INSTANCE(
            FIRST_INSTANCE(
                FIRST_INSTANCE(i.end_time, a.end_time),
                ia.end_time),
            t.end_time)
-- end


