----------------------------------------------------------------
-- Q5: 
--   List the last name of the authors with a matching id of
--   value (I3).
-- Feature:
--   Function in the SELECT statement
----------------------------------------------------------------
-- init
CREATE TABLE db2_ps_get_author_name_return_tbl(
    taupsm_result CHARACTER(50),
    author_id CHARACTER(10),
    begin_time DATE, end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_get_author_name(
    IN min_time DATE, IN max_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  INSERT INTO db2_ps_get_author_name_return_tbl
      SELECT a.last_name, a.author_id,
          a.begin_time AS begin_time,
          a.end_time AS end_time
        FROM author a
        WHERE a.begin_time $REL1 min_time AND
          a.begin_time $REL2 max_time;
END
-- end

-- sql
CALL db2_ps_proc_get_author_name($TIME_PERIOD)
-- end

-- sql
SELECT t.taupsm_result,
    FIRST_INSTANCE(
        i.begin_time,
        FIRST_INSTANCE(ia.begin_time, t.begin_time)) AS begin_time,
    LAST_INSTANCE(
        i.end_time,
        LAST_INSTANCE(ia.end_time, t.end_time)) AS end_time
  FROM item i, item_author ia, db2_ps_get_author_name_return_tbl t
--    TABLE(db2_ps_get_author_name(CAST('I3' AS CHARACTER(10)),
--                                 i.begin_time, i.end_time)) t
  WHERE i.id = 'I100' AND
    ia.item_id = i.id AND
    ia.author_id = t.author_id AND
      FIRST_INSTANCE(
          i.begin_time,
          FIRST_INSTANCE(ia.begin_time, t.begin_time)) <
        LAST_INSTANCE(
            i.end_time,
            LAST_INSTANCE(ia.end_time, t.end_time))
-- end


