----------------------------------------------------------------
-- Q2:
--   Find the title of the item which has matching author
--   first name (Ben).
-- Feature:
--   SET with SELECT single row
----------------------------------------------------------------
--init
CREATE TABLE db2_ps_get_author_name_return_tbl(
    taupsm_result CHARACTER(50),
    author_id CHARACTER(10),
    begin_time DATE, end_time DATE)
--end

--init
CREATE TABLE author_id_tbl (
    author_id CHARACTER(10))
--end

--procedure
CREATE PROCEDURE db2_ps_proc_get_author_name(
    IN min_time DATE, IN max_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  INSERT INTO db2_ps_get_author_name_return_tbl
      SELECT a.first_name, ai.author_id, 
          a.begin_time,
          a.end_time 
        FROM author a, author_id_tbl ai
        WHERE a.author_id = ai.author_id AND
          a.begin_time $REL1 min_time AND
          a.begin_time $REL2 max_time;
END
--end

--sql
INSERT INTO author_id_tbl SELECT DISTINCT author_id FROM item_author
--end

--sql
CALL db2_ps_proc_get_author_name($TIME_PERIOD)
--end

--sql
SELECT i.title,
    LAST_INSTANCE(LAST_INSTANCE(i.begin_time, ia.begin_time), t.begin_time),
    FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, ia.end_time), t.end_time)
  FROM item i, item_author ia, db2_ps_get_author_name_return_tbl t
  WHERE i.id = ia.item_id AND
    t.taupsm_result = 'Bai' AND
    t.author_id = ia.author_id AND
    LAST_INSTANCE(LAST_INSTANCE(i.begin_time, ia.begin_time), t.begin_time) <
      FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, ia.end_time), t.end_time)
--end




