----------------------------------------------------------------
-- Q20:
--   Retrieve the item title whose size (length*width*height)
--   is bigger than certain number (500000).
-- Feature:
--   ASSIGNMENT statement
----------------------------------------------------------------
-- init
CREATE TABLE db2_ps_sizeof_item_return_tbl(
    taupsm_result DOUBLE,
    item_id CHARACTER(10),
    begin_time DATE, end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_sizeof_item(
    IN min_time DATE, IN max_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DECLARE var_size DOUBLE;
    FOR size_cur AS
        SELECT i.id, i.length, i.width, i.height, i.begin_time, i.end_time
          FROM item i
          WHERE i.begin_time $REL1 min_time AND
            i.begin_time $REL2 max_time AND 
	    i.begin_time<i.end_time
      DO
        SET var_size = size_cur.length * size_cur.width * size_cur.height;
        INSERT INTO db2_ps_sizeof_item_return_tbl
          VALUES (var_size, size_cur.id,
                  size_cur.begin_time, size_cur.end_time);
    END FOR;
END
-- end

-- sql
CALL db2_ps_proc_sizeof_item($TIME_PERIOD)
-- end

-- sql
SELECT i.title,
    LAST_INSTANCE(i.begin_time, t.begin_time),
    FIRST_INSTANCE(i.end_time, t.end_time)
  FROM item i, db2_ps_sizeof_item_return_tbl t
-- TABLE (db2_ps_sizeof_item(i.length, i.width, i.height,
--                                         i.begin_time, i.end_time)) t
  WHERE t.taupsm_result > 500000 AND
    i.id = t.item_id AND
    LAST_INSTANCE(i.begin_time, t.begin_time) <
        FIRST_INSTANCE(i.end_time, t.end_time)
-- end


