----------------------------------------------------------------
-- This is outdated. Need to be re-generated.
-- Q17b:
--   Return the first n ids of the items whose descriptions
--   contain a certain word ("hockey") and for which the number
--   of pages is less than 500 if at least one author is Canadian.
--   (n is an input parameter)
--   Also return the relevant date for each id.
--   If all n are evaluated, results will be sorted by id.
-- Feature:
--   1. many time-varying variables
--   2. two time-varying tables
--   3. nested loop
--   4. multiple FETCHes in a loop
--   5. multiple SET of variables
--   6. a FETCH in the ELSE but not in the THEN part
--   7. function call
--   8. LEAVE statement
--   9. Both CURSOR and FOR 
--  10. INSERT and ELSE statement on arrays
--  11. procedure call that returns a time-varying result
----------------------------------------------------------------
-- init
CREATE TABLE is_small_book_tbl (
    result_is_small_book INT, item_id CHARACTER(10),
    begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE is_small_book_tbl_local (
    result INT, item_id CHARACTER(10),
    begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE item_TS (time_point DATE)
-- end

-- init
INSERT INTO item_TS
    SELECT begin_time AS time_point FROM item
    UNION
    SELECT end_time AS time_point FROM item
-- end

-- init
CREATE VIEW item_CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                       ts2.time_point AS end_time
                     FROM item_TS AS ts1, item_TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                         NOT EXISTS(SELECT time_point
                                      FROM item_TS
                                      WHERE time_point > ts1.time_point AND
                                          time_point < ts2.time_point)
                                      ORDER BY ts1.time_point) AS X
-- end

-- init
CREATE TABLE has_canadian_TS (time_point DATE)
-- end

-- init
CREATE TABLE has_canadian_tbl (result_has_canadian INT,
                               begin_time DATE,
                               end_time DATE)
-- end

-- init
INSERT INTO has_canadian_TS
    SELECT begin_time AS time_point FROM has_canadian_tbl
    UNION
    SELECT end_time AS time_point FROM has_canadian_tbl
-- end

-- init
CREATE VIEW has_canadian_CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                       ts2.time_point AS end_time
                     FROM has_canadian_TS AS ts1, has_canadian_TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                         NOT EXISTS(SELECT time_point
                                      FROM has_canadian_TS
                                      WHERE time_point > ts1.time_point AND
                                          time_point < ts2.time_point)
                                      ORDER BY ts1.time_point) AS X
-- end

-- init
CREATE TABLE is_small_book_TS (time_point DATE)
-- end

-- init
INSERT INTO is_small_book_TS
    SELECT begin_time AS time_point FROM is_small_book_tbl
    UNION
    SELECT end_time AS time_point FROM is_small_book_tbl
-- end

-- init
CREATE VIEW is_small_book_CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                       ts2.time_point AS end_time
                     FROM has_canadian_TS AS ts1, has_canadian_TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                         NOT EXISTS(SELECT time_point
                                      FROM has_canadian_TS
                                      WHERE time_point > ts1.time_point AND
                                          time_point < ts2.time_point)
                                      ORDER BY ts1.time_point) AS X
-- end

-- init
CREATE TABLE taupsm_RETURN_tbl(taupsm_item_id CHARACTER(10),
                               sometime DATE,
                               begin_time DATE,
                               end_time DATE)
--    first_n INT, begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE temp_item_id_tbl (taupsm_item_id CHARACTER(10),
                               sometime DATE)
-- end

-- init
CREATE TABLE return_item_id_tbl (taupsm_item_id CHARACTER(10),
                                 sometime DATE,
                                 begin_time DATE,
                                 end_time DATE)
-- end


-- procedure
CREATE PROCEDURE db2_ps_is_small_book(IN in_item_id CHARACTER(10))
--  RETURNS TABLE (result INT, item_id CHARACTER(10),
--                 begin_time DATE, end_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DELETE FROM is_small_book_tbl;
    FOR num_pages_cur AS
       SELECT number_of_pages, item_id, begin_time, end_time
         FROM item
         WHERE item_id = in_item_id
    DO
      IF (num_pages_cur.number_of_pages <= 500)
        THEN
          INSERT INTO is_small_book_tbl
            VALUES (1, num_pages_cur.id,
                    num_pages_cur.begin_time, num_pages_cur.end_time);
        ELSE
          INSERT INTO is_small_book_tbl
            VALUES (0, num_pages_cur.id,
                    num_pages_cur.begin_time, num_pages_cur.end_time);
      END IF;
    END FOR;
--    RETURN SELECT * FROM is_small_book_tbl;
END
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_has_author_canadian(IN in_item_id CHARACTER(10))
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN 
    FOR result_cur AS
      SELECT
          LAST_INSTANCE(ia.begin_time, a.begin_time) AS begin_time,
          FIRST_INSTANCE(ia.end_time, a.end_time) AS end_time
        FROM item_author ia, author a
        WHERE ia.item_id = in_item_id AND a.author_id = ia.author_id
          AND a.name_of_country = 'Canada'
          AND LAST_INSTANCE(ia.begin_time, a.begin_time) <
              FIRST_INSTANCE(ia.end_time, a.end_time)
    DO
      INSERT INTO has_canadian_tbl VALUES (1, result_cur.begin_time,
                                           result_cur.end_time);
    END FOR;
  END
-- end

-- function
CREATE PROCEDURE db2_ps_proc_get_first_n_items_about_hockey(IN first_n INT)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  -- block 1
  -- needed for later sorting
    DECLARE temp_item_id CHARACTER(10);
    DECLARE temp_when_is_available DATE;
    DECLARE temp_date_of_release DATE;
    DECLARE relevant_date DATE;
--    DECLARE has_canadian INT;
    DECLARE count INT;

    DECLARE all_items_curr_begin_time DATE;
    DECLARE all_items_curr_end_time DATE;

    DECLARE hockey_not_found_boolean INT;

    DECLARE min_scope1 DATE;
    DECLARE max_scope1 DATE;
    DECLARE old_min_scope1 DATE;

    DECLARE all_items_cur_COUNT INT;

    DECLARE first_time INT;

    DECLARE hockey_not_found CONDITION FOR SQLSTATE '02000';
    DECLARE all_items_cur CURSOR FOR
      SELECT i.id, i.when_is_available, i.date_of_release,
          item_CP.begin_time, item_CP.end_time
        FROM item_CP, item i
        WHERE i.description LIKE '%hockey%'
            AND i.begin_time <= item_CP.begin_time
            AND item_CP.begin_time < i.end_time
        ORDER BY item_CP.begin_time;
    DECLARE CONTINUE HANDLER FOR hockey_not_found
        SET hockey_not_found_boolean = 1;
    SET count = 0;
    SET hockey_not_found_boolean = 0;
    SET first_time = 1;

    OPEN all_items_cur;
 
    FETCH all_items_cur INTO
        temp_item_id, temp_when_is_available, temp_date_of_release,
        min_scope1, max_scope1;

    REPEAT -- block 2
      FETCH all_items_cur INTO
        temp_item_id, temp_when_is_available, temp_date_of_release,
        min_scope1, max_scope1;

      SET all_items_cur_COUNT = 0;

      while_loop: WHILE (hockey_not_found_boolean = 0) DO
        CALL db2_ps_proc_has_author_canadian(temp_item_id);
        FOR has_canadian_curr AS
          SELECT has_canadian_tbl.result_has_canadian,
              has_canadian_CP.begin_time, has_canadian_CP.end_time
            FROM has_canadian_CP, has_canadian_tbl
            WHERE has_canadian_tbl.begin_time <= has_canadian_CP.begin_time
              AND has_canadian_CP.begin_time < has_canadian_tbl.end_time
            ORDER BY has_canadian_CP.begin_time
        DO
--          INSERT INTO is_small_book_tbl 
--            SELECT * FROM TABLE(db2_ps_is_small_book(temp_item_id,
--                                                     min_scope2,
--                                                     max_scope2)) AS x;
          CALL db2_ps_is_small_book(temp_item_id);
             
          FOR is_small_book_curr AS
            SELECT is_small_book_tbl.result_is_small_book,
                is_small_book_CP.begin_time,
                is_small_book_CP.end_time
              FROM is_small_book_CP, is_small_book_tbl
              WHERE is_small_book_tbl.begin_time <= is_small_book_CP.begin_time
                  AND is_small_book_CP.begin_time < is_small_book_tbl.end_time
              ORDER BY is_small_book_CP.begin_time
          DO
            IF (has_canadian_curr.result_has_canadian = 1 AND
                is_small_book_curr.result_is_small_book = 1)
              THEN
                IF (MOD(count, 2) = 0)
                  THEN
                    SET relevant_date = temp_when_is_available;
                  ELSE
                    SET relevant_date = temp_date_of_release;
                END IF;
                INSERT INTO temp_item_id_tbl VALUES (
                    temp_item_id, relevant_date);
--                    temp_all_items.id, relevant_date);
                SET count = count + 1;
                IF (count >= first_n)
                  THEN
                    FOR temp_item_id_order_curr AS
                      SELECT taupsm_item_id, sometime
                        FROM temp_item_id_tbl
                        ORDER BY taupsm_item_id
                    DO
                      INSERT INTO return_item_id_tbl
                        VALUES (temp_item_id_order_curr.taupsm_item_id,
 		                temp_item_id_order_curr.sometime,
                                is_small_book_curr.begin_time,
                                is_small_book_curr.end_time);
                    END FOR;
		    LEAVE while_loop;
                  ELSE
	            FETCH all_items_cur INTO
                        temp_item_id, temp_when_is_available,
                        temp_date_of_release,
                        all_items_curr_begin_time,
                        all_items_curr_end_time;
                    IF hockey_not_found_boolean = 1
                      THEN
                        SET hockey_not_found_boolean = 1;
                      ELSE
                        IF (all_items_curr_begin_time > min_scope1)
                          THEN
--			    FETCH PRIOR all_items_cur INTO
 --                               temp_item_id, temp_when_is_available,
 --                               temp_date_of_release, min_scope1, max_scope1;
     	                    SET hockey_not_found_boolean = 1;
                          ELSE
                            SET all_items_cur_COUNT =
                                all_items_cur_COUNT + 1;
                        END IF;
                    END IF;
                END IF;
            END IF;

--            FETCH PRIOR all_item_cur_COUNT all_item_cur_COUNT;
                  
          END FOR;
        END FOR;
      END WHILE;

      FOR return_item_id_tbl_curr AS
        SELECT * FROM return_item_id_tbl
      DO
        INSERT INTO taupsm_RETURN_tbl
          VALUES (return_item_id_tbl_curr.taupsm_item_id,
                  return_item_id_tbl_curr.sometime,
                  return_item_id_tbl_curr.begin_time,
                  return_item_id_tbl_curr.end_time);
      END FOR;

      DELETE FROM temp_item_id_tbl;

      SET COUNT = 0;

      REPEAT
        SET old_min_scope1 = min_scope1;
        FETCH all_items_cur INTO
             temp_item_id, temp_when_is_available, temp_date_of_release;
      	     min_scope1, max_scope1;

--        SET hockey_not_found_boolean = hockey_not_found;

        IF (hockey_not_found_boolean = 0)
          THEN
--            FETCH PRIOR all_items_cur INTO
--                temp_item_id, temp_when_is_available, temp_date_of_release;
        END IF;

      UNTIL hockey_not_found_boolean = 1 OR min_scope1 > old_min_scope1
      END REPEAT;
    UNTIL hockey_not_found_boolean = 1
    END REPEAT;
    CLOSE all_items_cur;
END
-- end

-- function
CREATE FUNCTION db2_ps_get_first_n_items_about_hockey(first_n INT)
  RETURNS TABLE (item_id CHARACTER(10), sometime DATE, begin_time DATE, end_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
  CALL db2_ps_proc_get_first_n_items_about_hockey(first_n);
  RETURN SELECT * FROM taupsm_RETURN_tbl;
END
-- end

-- sql
SELECT * FROM TABLE(db2_ps_get_first_n_items_about_hockey(10)) AS x
-- end


