----------------------------------------------------------------
-- Q17:
--   Return the first id of the items whose descriptions contain
--   a certain word ("hockey").
-- Feature:
--   LEAVE statement
-- NOTE: retained the IF statements; no need to convert to CASE
----------------------------------------------------------------
-- init
CREATE TABLE get_first_item_about_hockey_return_tbl(
    taupsm_result CHARACTER(10),
    begin_time DATE,
    end_time DATE)
-- end

-- init
CREATE TABLE TS (time_point DATE)
-- end

-- init
INSERT INTO TS 
    SELECT begin_time AS time_point FROM item
    UNION
    SELECT end_time AS time_point FROM item
-- end

-- init
CREATE TABLE for_loop_tbl (item_id CHARACTER(10), insert_order INT)
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_get_first_item_about_hockey()
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DECLARE return_id CHARACTER(10);
    DECLARE first_time INT;
    DECLARE prev_item_id CHARACTER(10);
    DECLARE prev_begin_time DATE;
    DECLARE prev_end_time DATE;
    DECLARE insert_order INT;
    SET first_time = 1;
--    INSERT INTO test
--        SELECT i.id AS item_id,
--            CP.begin_time AS begin_time,
--            CP.end_time AS end_time
--        FROM item i, CP
--        WHERE i.description LIKE '%hockey%' AND
--            i.begin_time <= CP.begin_time AND
--            CP.begin_time < i.end_time
--        ORDER BY CP.begin_time;
    SET insert_order = 0;
    FOR all_items AS
        SELECT i.id AS item_id,
            CP.begin_time AS begin_time,
            CP.end_time AS end_time 
        FROM item i, CP
        WHERE i.description LIKE '%hockey%' AND
            i.begin_time <= CP.begin_time AND
            CP.begin_time < i.end_time
        ORDER BY CP.begin_time
      DO
        IF first_time = 1
          THEN
            SET first_time = 0;
          ELSE
            IF (all_items.begin_time <> prev_begin_time)
              THEN
                SET return_id = '';
--                FOR sub_items AS
--                  SELECT * FROM for_loop_tbl
--                  DO
--INSERT INTO test VALUES (sub_items.item_id, prev_begin_time, prev_end_time);
--                END FOR;
                for_loop: FOR sub_items AS
                  SELECT item_id FROM for_loop_tbl ORDER BY insert_order
                  DO
--INSERT INTO test VALUES (sub_items.item_id, prev_begin_time, prev_end_time);
                    SET return_id = sub_items.item_id;
                    LEAVE for_loop;
                END FOR;
                INSERT INTO get_first_item_about_hockey_return_tbl
                    VALUES (return_id,
                            prev_begin_time,
                            prev_end_time);
                DELETE FROM for_loop_tbl;
            END IF;
        END IF;
        INSERT INTO for_loop_tbl VALUES (all_items.item_id, insert_order);
        SET insert_order = insert_order + 1;
        SET prev_item_id = all_items.item_id;
        SET prev_begin_time = all_items.begin_time;
        SET prev_end_time = all_items.end_time;
    END FOR;
    for_loop: FOR sub_items AS
      SELECT item_id FROM for_loop_tbl ORDER BY insert_order
      DO
        SET return_id = sub_items.item_id;
        LEAVE for_loop;
      END FOR;
      INSERT INTO get_first_item_about_hockey_return_tbl
          VALUES (return_id,
                  prev_begin_time,
                  prev_end_time);
      DELETE FROM for_loop_tbl;
END
-- end

-- sql
CALL db2_ps_proc_get_first_item_about_hockey()
-- end

-- sql
SELECT i.id,
    LAST_INSTANCE(i.begin_time, t.begin_time) AS begin_time,
    FIRST_INSTANCE(i.end_time, t.end_time) AS end_time
  FROM item i, get_first_item_about_hockey_return_tbl t
  WHERE i.id = t.taupsm_result AND
      LAST_INSTANCE(i.begin_time, t.begin_time) <
          FIRST_INSTANCE(i.end_time, t.end_time)
-- end


