-----------------------------------------------------------------
-- applied optimization of non-temporal function, inconsistent
-- Q10:
--   List the item titles ordered alphabetically by publisher
--   name, with release date within a certain time period
--   (from 1990-01-01 to 1995-01-01)
-- Feature:
--   IF without CURSOR
-----------------------------------------------------------------
-- init
CREATE TABLE db2_ps_item_of_90s_return_tbl(
    taupsm_result INT, date_of_release DATE, begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE date_of_release_tbl (date_of_release DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_item_of_90s()
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  INSERT INTO db2_ps_item_of_90s_return_tbl
      SELECT
          CASE WHEN ((dr.date_of_release >= '1990-01-01') AND
              (dr.date_of_release < '1995-01-01'))
            THEN 1
            ELSE 0
          END,
          dr.date_of_release,
          LAST_INSTANCE(i.begin_time, dr.begin_time) AS                 	      begin_time
	  LAST_INSTANCE(i.end_time, dr.end_time) AS end_time		          
        FROM date_of_release_tbl dr, item i
        WHERE dr.date_of_release = i.date_of_release AND
             LAST_INSTANCE(i.begin_time, dr.begin_time) < 
                FIRST_INSTANCE(i.end_time, dr.end_time);
  END
-- end

-- sql
INSERT INTO date_of_release_tbl SELECT DISTINCT date_of_release FROM item
-- end

-- sql
CALL db2_ps_proc_item_of_90s()
-- end

-- sql
SELECT i.title, p.name,
    LAST_INSTANCE(
        LAST_INSTANCE(
            LAST_INSTANCE(p.begin_time, i.begin_time), ip.begin_time),
        t.begin_time) AS begin_time,
    FIRST_INSTANCE(
        FIRST_INSTANCE(
            FIRST_INSTANCE(p.end_time, i.end_time), ip.end_time),
        t.end_time) AS end_time
  FROM publisher p, item i, item_publisher ip, db2_ps_item_of_90s_return_tbl t
  WHERE i.id = ip.item_id AND
    ip.publisher_id = p.publisher_id AND
    t.date_of_release = i.date_of_release AND
    t.taupsm_result = 1 AND
    LAST_INSTANCE(
        LAST_INSTANCE(
            LAST_INSTANCE(p.begin_time, i.begin_time), ip.begin_time),
        t.begin_time) <
      FIRST_INSTANCE(
          FIRST_INSTANCE(
              FIRST_INSTANCE(p.end_time, i.end_time), ip.end_time),
          t.end_time)
  ORDER BY p.name
-- end

