----------------------------------------------------------------
-- Q9:
--   Return the ISBN of an item with id attribute value (I5)
-- Feature:
--   CALL procedure from function
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item

CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point)

CREATE PROCEDURE maxmap_proc_get_isbn_with_item_id(
    IN item_id_in CHARACTER(10),
    IN begin_time DATE,
    IN end_time DATE,
    OUT isbn_out CHARACTER VARYING(20))
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    SET isbn_out =
        (SELECT i.isbn
           FROM item i
           WHERE i.id = item_id_in AND
               i.begin_time <= begin_time AND
               begin_time < i.end_time);
  END;

CREATE FUNCTION maxmap_invoke_proc(
    IN item_id_in CHARACTER(10),
    IN begin_time DATE,
    IN end_time DATE)
  RETURNS CHARACTER VARYING(20)
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE taupsm_result CHARACTER VARYING(20);
    CALL maxmap_proc_get_isbn_with_item_id(
          item_id_in, begin_time, end_time, taupsm_result);
    RETURN taupsm_result;
  END;

SELECT i.isbn, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE i.isbn = maxmap_invoke_proc('I5', CP.begin_time, CP.end_time) AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time;

