----------------------------------------------------------------
-- Q6:
--   Return item information where some authors are from
--   certain country (Canada).
-- Feature:
--   CASE statement
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_is_from_country((aid CHARACTER(10),
                                        country VARCHAR(50), 
                                        begin_time DATE)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE coutry_name VARCHAR(50);
    SET coutry_name =
       (SELECT name_of_country
          FROM author
          WHERE author_id = aid AND
          begin_time <= begin_time_in AND
          begin_time_in < end_time);
    CASE WHEN (country_name = country)
    THEN
      RETURN TRUE;
    ELSE
      RETURN FALSE;
  END;

SELECT DISTINCT i.*, CP.begin_time, CP.end_time
  FROM item i, author a, item_author ia, CP
  WHERE i.id = ia.item_id AND a.author_id = ia.author_id AND
    maxmap_is_from_country(a.name_of_country, 'Canada') AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time AND
    a.begin_time <= CP.begin_time AND
    CP.begin_time < a.end_time AND
    ia.begin_time <= CP.begin_time AND
    CP.begin_time < ia.end_time;

