----------------------------------------------------------------
-- Q5: 
--   List the last name of the authors with a matching id of
--   value (I3).
-- Feature:
--   Function in the SELECT statement
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_get_author_name(item_id_in CHARACTER(10),
                                       begin_time DATE, end_time DATE)
  RETURNS CHARACTER(50)
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE taupsm_result CHARACTER(50);
    SET taupsm_result =
        (SELECT a.last_name
           FROM author a, item_author ia
           WHERE ia.author_id = a.author_id AND
               ia.item_id = item_id_in AND
               a.begin_time <= begin_time AND
               begin_time < a.end_time AND
               ia.begin_time <= begin_time AND
               begin_time < ia.end_time);
    RETURN taupsm_result;
  END;

SELECT maxmap_get_author_name('I3', CP.begin_time, CP.end_time),
    CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE i.id = 'I3' AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time;

