----------------------------------------------------------------
-- Q3:
--   Group items released in a certain year (1990),
--   by publisher name and calculated the total number of
--   items for each group.
-- Feature:
--   RETURN with SELECT single row
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher
  UNION
  SELECT begin_time AS time_point FROM item_publisher
  UNION
  SELECT end_time AS time_point FROM item_publisher);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_get_release_date(item_id CHARACTER(10),
                                        begin_time DATE, end_time DATE)
  RETURNS ROW DATE
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    RETURN (SELECT i.date_of_release FROM item i
              WHERE i.id = item_id AND
              i.begin_time <= begin_time AND
              begin_time < i.end_time);
  END;

SELECT p.name, SUM(i.quantity_in_stock), CP.begin_time, CP.end_time
  FROM item i, publisher p, item_publisher ip, CP
  WHERE i.id = ip.item_id AND
    ip.publisher_id = p.publisher_id AND
    maxmap_get_release_date(i.id, CP.begin_time, CP.end_time) BETWEEN
        '1990-01-01' AND '1991-01-01' AND
    p.begin_time <= CP.begin_time AND
    CP.begin_time < p.end_time AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time
GROUP BY p.name, CP.begin_time, CP.end_time;

