----------------------------------------------------------------
-- Q20:
--   Retrieve the item title whose size (length*width*height)
--   is bigger than certain number (500000).
-- Feature:
--   ASSIGNMENT statement
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_sizeof_item(in_item_id CHARACTER(10))
  RETURNS NUMBER
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE length NUMBER;
    DECLARE width NUMBER;
    DECLARE height NUMBER;
    DECLARE size NUMBER;
    SET length = 
      (SELECT length
         FROM item
         WHERE id = in_item_id AND
         begin_time <= begin_time_in AND
         begin_time_in < end_time);
    SET width = 
      (SELECT width
         FROM item
         WHERE id = in_item_id AND
         begin_time <= begin_time_in AND
         begin_time_in < end_time);
    SET height = 
      (SELECT height
         FROM item
         WHERE id = in_item_id AND
         begin_time <= begin_time_in AND
         begin_time_in < end_time);
    SET size = length * width * height;
    RETURN size;
  END;

SELECT i.title, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE maxmap_sizeof_item(i.id) > 500000 AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time;

