----------------------------------------------------------------
-- Q19:
--   Retrieve the item titles related by certain item with id
--   attribute value (I7).
-- Feature:
--   FOR statement
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM related_item
  UNION
  SELECT end_time AS time_point FROM related_item);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_get_related_items(bid CHARACTER(10),
                                         begin_time DATE,
                                         end_time DATE)
  RETURNS ROW (title CHARACTER(100)) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE maxmap_return_tbl(title CHARACTER(100));
    FOR related AS
      SELECT i.title FROM item i, related_item ri
        WHERE i.id = ri.related_id AND ri.item_id = bid AND
          i.begin_time <= begin_time AND
          begin_time < i.end_time AND
          ri.begin_time <= begin_time AND
          begin_time < ri.end_time;
    DO
      INSERT INTO maxmap_return_tbl VALUES (related.title);
    END FOR;
    RETURN maxmap_return_tbl;
  END;

SELECT t.*, CP.begin_time, CP.end_time
  FROM CP, get_related_items('I7', CP.begin_time, CP.end_time) t

