----------------------------------------------------------------
-- Q17b:
--   Return the first n ids of the items whose descriptions
--   contain a certain word ("hockey") and for which the number
--   of pages is less than 500 if at least one author is Canadian.
--   (n is an input parameter)
--   Also return the relevant date for each id.
--   If all n are evaluated, results will be sorted by id.
-- Feature:
--   1. many time-varying variables
--   2. two time-varying tables
--   3. nested loop
--   4. multiple FETCHes in a loop
--   5. multiple SET of variables
--   6. a FETCH in the ELSE but not in the THEN part
--   7. function call
--   8. LEAVE statement
--   9. Both CURSOR and FOR 
--  10. INSERT and ELSE statement on arrays
--  11. procedure call that returns a time-varying result
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION is_small_book(in_item_id INT)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE num_pages INT;
    SET num_pages = SELECT number_of_pages FROM item WHERE id = in_item_id;
    RETURN (num_pages <= 500);
  END


CREATE PROCEDURE is_author_canadian(in_item_id INT IN, has_canadian BOOLEAN OUT)
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    SET has_canadian = EXISTS (SELECT a.name_of_country
        FROM item_author ia, author a
        WHERE ia.item_id = in_item_id AND a.author_id = ia.author_id AND
            a.name_of_country = 'Canada');
  END


CREATE FUNCTION get_first_n_items_about_hockey(first_n INT)
  RETURNS ROW (taupsm_item_id INT, sometime DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    -- needed for later sorting
    DECLARE temp_item_id_tbl ROW (taupsm_item_id INT,
                                  sometime DATE) ARRAY;
    DECLARE return_item_id_tbl ROW (taupsm_item_id INT,
                                    sometime DATE) ARRAY;
    DECLARE temp_item_id CHARACTER(10);
    DECLARE temp_when_is_available DATE;
    DECLARE temp_date_of_release DATE;
    DECLARE relevant_date DATE;
    DECLARE has_canadian BOOLEAN;
    DECLARE count INT;
    SET count = 0;
    DECLARE CURSOR all_items_cur FOR
      SELECT i.id, i.when_is_available, i.date_of_release
        FROM item i
        WHERE i.description LIKE '%hockey%';
    DECLARE hockey_not_found CONDITION FOR SQLSTATE '02000';
    OPEN all_items_cur;
    FETCH all_items_cur INTO
        temp_item_id, temp_when_is_available, temp_date_of_release;
    while_loop: WHILE NOT(hockey_not_found) DO
      CALL has_canadian_author(temp_item_id, has_canadian);
      IF (has_canadian AND is_small_book(temp_item_id))
      THEN 
        IF (count % 2 = 0)
        THEN
            SET relevant_date = temp_when_is_available;
        ELSE
            SET relevant_date = temp_date_of_release;
        END IF;
        INSERT INTO temp_item_id_tbl VALUES (
            temp_item_id, relevant_date);
        SET count = count + 1;
        IF (count >= first_n)
        THEN
            FOR temp_item_id_order AS
              SELECT * FROM temp_item_id_tbl ORDER BY taupsm_item_id
            DO
              INSERT INTO return_item_id_tbl
	          VALUES (temp_item_id_order.taupsm_item_id,
		          temp_item_id_order.sometime);
            END FOR;
            LEAVE while_loop;
        ELSE FETCH all_items_cur INTO
            temp_item_id, temp_when_is_available, temp_date_of_release;
        END IF;
      END IF;
    END WHILE;
    CLOSE all_items_cur;
    RETURN return_item_id_tbl;
  END;

SELECT g.*, CP.begin_time, CP.end_time
  FROM get_first_n_items_about_hockey(10) AS g, CP
  WHERE g.begin_time <= CP.begin_time AND
    CP.begin_time < g.end_time;
