----------------------------------------------------------------
-- Q17:
--   Return the first id of the items whose descriptions contain
--   a certain word ("hockey").
-- Feature:
--   LEAVE statement
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_get_first_item_about_hockey(begin_time DATE,
                                                   end_time DATE)
  RETURNS CHARACTER(10)
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_id CHARACTER(10);
    for_loop: FOR all_items AS
      SELECT i.title FROM item i
        WHERE i.description LIKE '%hockey%' AND
            i.begin_time <= begin_time AND
            begin_time < i.end_time
    DO
      SET return_id = all_items.id;
      LEAVE for_loop;
    END FOR;
    RETURN return_id;
  END;

SELECT i.id, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE i.id = maxmap_get_first_item_about_hockey(CP.begin_time,
                                                  CP.end_time) AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time;

