----------------------------------------------------------------
-- Q14:
--   Return the names of publishers who publish books between
--   a period of time from 1990-01-01 to 1991-01-01 but
--   do not have FAX number.
-- Feature:
--   Local cursor declaration
--   FETCH, OPEN, and CLOSE statements
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher
  UNION
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM item_publisher
  UNION
  SELECT end_time AS time_point FROM item_publisher);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_is_released_in_period(pid CHARACTER(10),
                                             start_date DATE, end_date DATE,
                                             begin_time DATE, end_time DATE)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE item_id CHARACTER(10);
    DECLARE no_tuple CONDITION FOR SQLSTATE '02000';
    DECLARE item_cursor CURSOR FOR
        SELECT i.id FROM item i, item_publisher ip
          WHERE i.id = ip.item_id AND
            ip.publisher_id = pid AND
            date_of_release BETWEEN start_date AND end_date AND
            i.begin_time <= begin_time AND
            begin_time < i.end_time;
    OPEN item_cursor;
    FETCH item_cursor INTO item_id;
    CLOSE item_cursor;
    RETURN no_tuple;
  END;

SELECT p.name, CP.begin_time, CP.end_time
  FROM publisher p, CP
  WHERE maxmap_is_released_in_period(p.publisher_id,
                                     '1990-01-01', '1991-01-01',
                                     CP.begin_time, CP.end_time) AND
    p.begin_time <= CP.begin_time AND
    CP.begin_time < p.end_time AND
    fax_number IS NULL;

