----------------------------------------------------------------
-- Q11:
--   List the item titles in descending order by date of
--   release with date of release within a certain time
--   range (from 1990-01-01 to 1995-01-01).
-- Feature:
--   Temporary Table Creation
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_is_publised_in_period(item_id CHARACTER(10),
                                             start_date DATE, end_date DATE,
                                             begin_time DATE, end_time DATE)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    CREATE TEMPORARY TABLE temp_item AS (
        SELECT * FROM item i
          WHERE i.begin_time <= begin_time AND
            begin_time < i.end_time);
    RETURN EXISTS (SELECT * FROM temp_item
                     WHERE id = item_id AND
                       date_of_release BETWEEN start_date AND end_date);
  END;

SELECT i.title, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE maxmap_is_published_in_period(i.id, '1990-01-01', '1995-01-01',
                                      CP.begin_time, CP.end_time) AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time;

