----------------------------------------------------------------
-- Q8:
--   Return the publisher of an item with id attribute
--   value (I4).
-- Feature:
--   Loop name with FOR statement
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher
  UNION
  SELECT begin_time AS time_point FROM item_publisher
  UNION
  SELECT end_time AS time_point FROM item_publisher
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- function
CREATE FUNCTION db2_max_get_publisher_id_by_item_id(item_id CHARACTER(10),
                                                    begin_time_in DATE)
  RETURNS CHARACTER(10)
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE taupsm_result CHARACTER(10);
    FOR related AS
      SELECT i.id, ip.publisher_id FROM item i, item_publisher ip
        WHERE i.id = ip.item_id AND
          i.begin_time <= begin_time_in AND
          begin_time_in < i.end_time AND
          ip.begin_time <= begin_time_in AND
          begin_time_in < ip.end_time
    DO
      IF related.id = item_id
      THEN
        SET taupsm_result = related.publisher_id;
      END IF;
    END FOR;
    RETURN taupsm_result;
END
-- end

-- sql
SELECT p.*, CP.begin_time, CP.end_time
  FROM publisher p, CP
  WHERE p.publisher_id =
      db2_max_get_publisher_id_by_item_id(CAST('I100' AS CHARACTER(10)),
                                          CP.begin_time) AND
    p.begin_time <= CP.begin_time AND
    CP.begin_time < p.end_time
-- end



