----------------------------------------------------------------
-- The psm is changed. This is inconsistent
-- Q7b:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   REPEAT statement
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- procedure
CREATE PROCEDURE db2_max_proc_all_author_from_country_b(IN bid CHARACTER(10),
                                                        IN country VARCHAR(50),
                                                        IN begin_time_in DATE,
                                                        OUT taupsm_result INT)
  NO EXTERNAL ACTION
  READS SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DECLARE country_name VARCHAR(50);
    DECLARE SQLCODE INTEGER DEFAULT 0;
    DECLARE total_count INT;
    DECLARE country_cursor CURSOR FOR
        SELECT a.name_of_country
          FROM author a, item_author ia
          WHERE a.author_id = ia.author_id AND 
            a.begin_time <= begin_time_in AND
            begin_time_in < a.end_time AND
            ia.begin_time <= begin_time_in AND
            begin_time_in < ia.end_time AND
            ia.item_id = bid;
    SET taupsm_result = 1;
    SET total_count = 0;
    OPEN country_cursor;
    FETCH country_cursor INTO country_name;
    IF SQLCODE <> 0
      THEN SET taupsm_result = 0;
      ELSE
        repeat1: REPEAT
          IF (country_name <> country)
            THEN
              SET taupsm_result = 0;
              LEAVE repeat1;
            ELSE FETCH country_cursor INTO country_name;
          END IF;
        UNTIL SQLCODE <> 0
        END REPEAT;
    END IF;
    CLOSE country_cursor;
END
-- end

-- function
CREATE FUNCTION db2_max_all_author_from_country_b(bid CHARACTER(10),
                                                  country CHARACTER(20),
                                                  begin_time_in DATE)
  RETURNS INT
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE taupsm_result INT;
    CALL db2_max_proc_all_author_from_country_b(
        bid, country, begin_time_in, taupsm_result);
    RETURN taupsm_result;
END
-- end

-- sql
SELECT i.*, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE db2_max_all_author_from_country_b(i.id,
                                          CAST('Canada' AS CHARACTER(50)),
                                          CP.begin_time) = 1 AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time
-- end



