----------------------------------------------------------------
-- Q6:
--   Return item information where some authors are from
--   certain country (Canada).
-- Feature:
--   CASE statement
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- procedure
CREATE PROCEDURE db2_max_proc_is_from_country(IN country_name VARCHAR(50),
                                              IN country VARCHAR(50),
                                              OUT taupsm_result INT)
  READS SQL DATA
  LANGUAGE SQL
P1: BEGIN
    CASE
      WHEN country_name = country THEN
        SET taupsm_result = 1;
      ELSE
        SET taupsm_result = 0;
    END CASE;
END
-- end

-- function
CREATE FUNCTION db2_max_is_from_country(aid CHARACTER(10),
                                        country VARCHAR(50), 
                                        begin_time DATE)
  RETURNS INT
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE taupsm_result INT;
    DECLARE coutry_name VARCHAR(50);
    SET coutry_name =
       (SELECT name_of_country
          FROM author
          WHERE author_id = aid AND
          begin_time <= begin_time_in AND
          begin_time_in < end_time);
    CALL db2_max_proc_is_from_country(country_name, country,
                                      taupsm_result);
    RETURN taupsm_result;
END
-- end

-- sql
SELECT DISTINCT i.*, CP.begin_time, CP.end_time
  FROM item i, author a, item_author ia, CP
  WHERE i.id = ia.item_id AND a.author_id = ia.author_id AND
    db2_max_is_from_country(a.author_id,
                            CAST('Canada' AS VARCHAR(50)),
                            CP.begin_time) = 1 AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time AND
    a.begin_time <= CP.begin_time AND
    CP.begin_time < a.end_time AND
    ia.begin_time <= CP.begin_time AND
    CP.begin_time < ia.end_time
-- end


