----------------------------------------------------------------
-- Q17b:
--   Return the first n ids of the items whose descriptions
--   contain a certain word ("hockey") and for which the number
--   of pages is less than 500 if at least one author is Canadian.
--   (n is an input parameter)
--   Also return the relevant date for each id.
--   If all n are evaluated, results will be sorted by id.
-- Feature:
--   1. many time-varying variables
--   2. two time-varying tables
--   3. nested loop
--   4. multiple FETCHes in a loop
--   5. multiple SET of variables
--   6. a FETCH in the ELSE but not in the THEN part
--   7. function call
--   8. LEAVE statement
--   9. Both CURSOR and FOR 
--  10. INSERT and ELSE statement on arrays
--  11. procedure call that returns a time-varying result
----------------------------------------------------------------
-- init
CREATE TABLE temp_item_id_tbl(taupsm_item_id CHARACTER(10),
                              sometime DATE,
                              begin_time DATE,
                              end_time DATE)
-- end

-- init
CREATE TABLE return_item_id_tbl(taupsm_item_id CHARACTER(10),
                                sometime DATE,
                                begin_time DATE,
                                end_time DATE)
-- end

-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- procedure
CREATE FUNCTION db2_max_is_small_book(in_item_id CHARACTER(10),
                                      begin_time_in DATE)
  RETURNS INT
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE num_pages INT;
    SET num_pages =
        (SELECT number_of_pages
           FROM item
           WHERE id = in_item_id AND
           begin_time <= begin_time_in AND
           begin_time_in < end_time);
    IF (num_pages <= 500)
      THEN RETURN 1;
      ELSE RETURN 0;
    END IF;
  END
-- end

-- procedure
CREATE PROCEDURE db2_max_proc_has_canadian_author(
    IN in_item_id CHARACTER(10),
    IN begin_time_in DATE,
    OUT has_canadian INT)
  READS SQL DATA
  LANGUAGE SQL
P1: BEGIN
    IF (EXISTS (SELECT a.name_of_country
        FROM item_author ia, author a
        WHERE ia.item_id = in_item_id AND a.author_id = ia.author_id AND
            a.name_of_country = 'Canada' AND
            a.begin_time <= begin_time_in AND
            begin_time_in < a.end_time AND
            ia.begin_time <= begin_time_in AND
            begin_time_in < ia.end_time))
      THEN SET has_canadian = 1;
      ELSE SET has_canadian = 0;
    END IF;
  END
-- end

-- procedure
CREATE PROCEDURE db2_max_proc_get_first_n_items_about_hockey(
    IN first_n INT)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DECLARE temp_item_id CHARACTER(10);
    DECLARE temp_when_is_available DATE;
    DECLARE temp_date_of_release DATE;
    DECLARE var_begin_time DATE;
    DECLARE var_end_time DATE;
    DECLARE relevant_date DATE;
    DECLARE has_canadian INT;
    DECLARE count INT;
    DECLARE taupsm_status INT DEFAULT 0;
    DECLARE hockey_not_found CONDITION FOR SQLSTATE '02000';
    DECLARE all_items_cur CURSOR FOR
      SELECT i.id, i.when_is_available, i.date_of_release,
          CP.begin_time, CP.end_time
        FROM item i, CP
        WHERE i.description LIKE '%hockey%' AND
          i.begin_time <= CP.begin_time AND
          CP.begin_time < i.end_time;
    DECLARE CONTINUE HANDLER FOR hockey_not_found SET taupsm_status = 1;
    SET count = 0;
    OPEN all_items_cur;
    FETCH all_items_cur INTO
        temp_item_id, temp_when_is_available, temp_date_of_release,
        var_begin_time, var_end_time;
    while_loop: WHILE (taupsm_status = 0) DO
      CALL db2_max_proc_has_canadian_author(temp_item_id, var_begin_time,
                                            has_canadian);
      IF (has_canadian = 1 AND
          (db2_max_is_small_book(temp_item_id,
                                 var_begin_time) = 1))
        THEN 
          IF (MOD(count, 2) = 0)
            THEN
              SET relevant_date = temp_when_is_available;
            ELSE
              SET relevant_date = temp_date_of_release;
          END IF;
          INSERT INTO temp_item_id_tbl VALUES (
              temp_item_id, relevant_date, var_begin_time, var_end_time);
          SET count = count + 1;
          IF (count >= first_n)
            THEN
              FOR temp_item_id_order AS
                SELECT * FROM temp_item_id_tbl ORDER BY taupsm_item_id
              DO
                INSERT INTO return_item_id_tbl
	            VALUES (temp_item_id_order.taupsm_item_id,
		            temp_item_id_order.sometime,
                            var_begin_time, var_end_time);
              END FOR;
              LEAVE while_loop;
          ELSE FETCH all_items_cur INTO
              temp_item_id, temp_when_is_available, temp_date_of_release,
              var_begin_time, var_end_time;
        END IF;
      ELSE FETCH all_items_cur INTO
          temp_item_id, temp_when_is_available, temp_date_of_release,
          var_begin_time, var_end_time;
    END IF;
    END WHILE;
    CLOSE all_items_cur;
  END
-- end

-- sql
CALL db2_max_proc_get_first_n_items_about_hockey(10)
-- end

-- sql
SELECT * FROM return_item_id_tbl
-- end



