----------------------------------------------------------------
-- Q14:
--   Return the names of publishers who publish books between
--   a period of time from 1990-01-01 to 1991-01-01 but
--   do not have FAX number.
-- Feature:
--   Local cursor declaration
--   FETCH, OPEN, and CLOSE statements
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher
  UNION
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM item_publisher
  UNION
  SELECT end_time AS time_point FROM item_publisher
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- procedure
CREATE PROCEDURE db2_max_proc_is_released_in_period(
    IN pid CHARACTER(10), IN start_date DATE, IN end_date DATE,
    IN begin_time_in DATE, OUT taupsm_result INT)
  READS SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DECLARE item_id CHARACTER(10);
    DECLARE no_tuple CONDITION FOR SQLSTATE '02000';
    DECLARE item_cursor CURSOR FOR
        SELECT i.id FROM item i, item_publisher ip
          WHERE i.id = ip.item_id AND
            ip.publisher_id = pid AND
            date_of_release BETWEEN start_date AND end_date AND
            i.begin_time <= begin_time_in AND
            begin_time_in < i.end_time;
    DECLARE CONTINUE HANDLER FOR no_tuple
      SET taupsm_result = 0;
    SET taupsm_result = 1;
    OPEN item_cursor;
    FETCH item_cursor INTO item_id;
    CLOSE item_cursor;
END
-- end

-- function
CREATE FUNCTION db2_max_is_released_in_period(pid CHARACTER(10),
                                              start_date DATE,
                                              end_date DATE,
                                              begin_time_in DATE)
  RETURNS INT
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
  DECLARE taupsm_result INT;
  CALL ruizhang.db2_max_proc_is_released_in_period(
      pid, start_date, end_date, begin_time_in, taupsm_result);
  RETURN taupsm_result;
END
-- end

-- sql
SELECT p.name, CP.begin_time, CP.end_time
  FROM publisher p, CP
  WHERE fax_number IS NULL AND
    db2_max_is_released_in_period(
        p.publisher_id,
        CAST('1990-01-01' AS DATE),
        CAST('1991-01-01' AS DATE),
        CP.begin_time) = 1 AND
    p.begin_time <= CP.begin_time AND
    CP.begin_time < p.end_time
-- end


