----------------------------------------------------------------
-- Q7c:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   nested FETCHes
----------------------------------------------------------------
CREATE FUNCTION all_author_from_country_b(item_id_in CHARACTER(10),
                                                 country_in CHARACTER(20))
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE country_name CHARACTER(20);
    DECLARE author_id_var CHARACTER(10);
    DECLARE country_name_var CHARACTER(20);
    DECLARE author_id_var2 CHARACTER(10);
    DECLARE item_id_var2 CHARACTER(10);
    DECLARE item_author_not_found BOOLEAN;
    DECLARE country_cursor CURSOR FOR
        SELECT name_of_country
          FROM author;
    DECLARE author_not_found CONDITION FOR SQLSTATE '02000';
    OPEN author_cursor;
    FETCH author_cursor INTO country_name_var, author_id_var;
    DECLARE item_author_cursor CURSOR FOR
        SELECT author_id, item_id
          FROM item_author
          WHERE author_id = author_id_var AND 
            item_id = item_id_in;
    OPEN item_author_cursor;
    REPEAT
      FETCH item_author_cursor INTO author_id_var2, item_id_var2;
      SET item_author_not_found = author_not_found;
      IF (country_name_var <> country_in AND (NOT item_author_not_found))
      THEN
        BEGIN
          CLOSE author_cursor;
          CLOSE item_author_cursor;
          RETURN FALSE;
        END;
      ELSE FETCH author_cursor INTO country_name_var, author_id_var;
      END IF;
      UNTIL item_author_not_found;
    END REPEAT;
    CLOSE author_cursor;
    CLOSE item_author_cursor;
    RETURN TRUE;
  END;

SELECT * FROM item
  WHERE maxmap_all_author_from_country_b('I7', 'Canada');

